"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Positionable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("../../lib/dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Positionable = ({
  children,
  transformMatrix,
  width,
  height
}) => {
  // Throw if there is more than one child
  const childNode = _react.default.Children.only(children);
  const matrix = transformMatrix.map((n, i) => i < 12 ? n : Math.round(n));
  const newStyle = {
    width,
    height,
    marginLeft: -width / 2,
    marginTop: -height / 2,
    position: 'absolute',
    transform: (0, _dom.matrixToCSS)(matrix)
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasPositionable canvasInteractable",
    style: newStyle
  }, childNode);
};
exports.Positionable = Positionable;
Positionable.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  children: _propTypes.default.element.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  width: _propTypes.default.number.isRequired,
  height: _propTypes.default.number.isRequired
};