"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BorderResizeHandle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("../../lib/dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BorderResizeHandle = ({
  transformMatrix,
  zoomScale = 1
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasBorderResizeHandle canvasLayoutAnnotation",
  style: {
    transform: `${(0, _dom.matrixToCSS)(transformMatrix)} scale3d(${1 / zoomScale},${1 / zoomScale}, 1)`
  }
});
exports.BorderResizeHandle = BorderResizeHandle;
BorderResizeHandle.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  zoomScale: _propTypes.default.number
};