"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonsFooter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireDefault(require("react"));
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bottomBarCss = (0, _react.css)`
  animation: none !important; // disable the animation to prevent the footer from flickering
`;
const containerCss = (0, _react.css)`
  min-height: 40px;
`;
const contentCss = (0, _react.css)`
  width: 100%;
  max-width: 730px;
`;
const ButtonsFooter = exports.ButtonsFooter = /*#__PURE__*/_react2.default.memo(({
  cancelButtonText,
  nextButtonText,
  backButtonText,
  onNext,
  onBack,
  hideCancel = false,
  isNextDisabled = false
}) => {
  const integrationsUrl = (0, _use_kibana.useKibana)().services.application.getUrlForApp('integrations');
  return /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "s",
    position: "sticky",
    css: bottomBarCss
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    css: containerCss,
    "data-test-subj": "buttonsFooter"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: contentCss
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, !hideCancel && /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: integrationsUrl,
    color: "text",
    "data-test-subj": "buttonsFooter-cancelButton"
  }, cancelButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, onBack && /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    onClick: onBack,
    color: "text",
    "data-test-subj": "buttonsFooter-backButton"
  }, backButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.back",
    defaultMessage: "Back"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, onNext && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: onNext,
    isDisabled: isNextDisabled,
    "data-test-subj": "buttonsFooter-nextButton"
  }, nextButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.next",
    defaultMessage: "Next"
  })))))))));
});
ButtonsFooter.displayName = 'ButtonsFooter';