"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyIndexListPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EmptyIndexListPrompt = ({
  onRefresh,
  createAnyway,
  canSaveIndexPattern,
  addDataUrl,
  navigateToApp
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const createAnywayLink = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.createDataView.emptyState.createAnywayTxt",
    defaultMessage: "You can also {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => createAnyway(),
        "data-test-subj": "createAnyway"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.createDataView.emptyState.createAnywayLink",
        defaultMessage: "create a data view against hidden, system or default indices."
      }))
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "indexPatternEmptyState",
    color: "subdued",
    hasShadow: false,
    paddingSize: "xl",
    css: styles.wrapper
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.createDataView.emptyState.noDataTitle",
    defaultMessage: "Ready to try Kibana? First, you need data."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    css: styles.cardGrid,
    columns: 3,
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: styles.card,
    onClick: () => {
      navigateToApp('integrations', {
        path: '/browse'
      });
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "database",
      color: "subdued"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.integrationCardTitle",
      defaultMessage: "Add integration"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.integrationCardDescription",
      defaultMessage: "Add data from a variety of sources."
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    onClick: () => navigateToApp('home', {
      path: '#/tutorial_directory/fileDataViz'
    }),
    css: styles.card,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "document",
      color: "subdued"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.uploadCardTitle",
      defaultMessage: "Upload a file"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.uploadCardDescription",
      defaultMessage: "Import a CSV, NDJSON, or log file."
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: styles.card,
    onClick: () => {
      navigateToApp('home', {
        path: '#/tutorial_directory/sampleData'
      });
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "heatmap",
      color: "subdued"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.sampleDataCardTitle",
      defaultMessage: "Add sample data"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.createDataView.emptyState.sampleDataCardDescription",
      defaultMessage: "Load a data set and a Kibana dashboard."
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.footer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.footerItem
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.createDataView.emptyState.learnMore",
        defaultMessage: "Want to learn more?"
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: addDataUrl,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.createDataView.emptyState.readDocs",
        defaultMessage: "Read documentation"
      }))
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.footerItem
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.createDataView.emptyState.haveData",
        defaultMessage: "Think you already have data?"
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onRefresh,
        "data-test-subj": "refreshIndicesButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.createDataView.emptyState.checkDataButton",
        defaultMessage: "Check for new data"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "refresh",
        size: "s"
      }))
    }]
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), canSaveIndexPattern && createAnywayLink)));
};
exports.EmptyIndexListPrompt = EmptyIndexListPrompt;
const componentStyles = {
  wrapper: ({
    euiTheme
  }) => (0, _react2.css)({
    maxWidth: `calc(${euiTheme.size.xxl} * 19)`,
    margin: 'auto'
  }),
  cardGrid: (0, _react2.css)({
    justifyContent: 'center'
  }),
  card: ({
    euiTheme
  }) => (0, _react2.css)({
    minWidth: `calc(${euiTheme.size.xl} * 6)`
  }),
  footer: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.lightestShade,
    margin: `0 -${euiTheme.size.l} -${euiTheme.size.l}`,
    padding: euiTheme.size.l,
    borderRadius: `0 0 ${euiTheme.border.radius.small} ${euiTheme.border.radius.small}`
  }),
  footerItem: ({
    euiTheme
  }) => (0, _react2.css)({
    minWidth: `calc(${euiTheme.size.xl} * 7)`
  })
};