"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndicesTable = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../../../../constants");
var _actions = require("../../../../../store/actions");
var _selectors = require("../../../../../store/selectors");
var _follower_indices_table = require("./follower_indices_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.FOLLOWER_INDEX;
const mapStateToProps = state => ({
  apiStatusDelete: (0, _selectors.getApiStatus)(`${scope}-delete`)(state)
});
const mapDispatchToProps = dispatch => ({
  selectFollowerIndex: name => dispatch((0, _actions.selectDetailFollowerIndex)(name))
});
const FollowerIndicesTable = exports.FollowerIndicesTable = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_follower_indices_table.FollowerIndicesTable);