"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.read = read;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Unknown variant for internal use only for when plugins are not known.
 * @internal
 */

/**
 * Custom window type for loading bundles. Do not extend global Window to avoid leaking these types.
 * @internal
 */

/**
 * Reads the plugin's bundle declared in the global context.
 */
function read(name) {
  const coreWindow = window;
  const exportId = `plugin/${name}/public`;
  if (!coreWindow.__kbnBundles__.has(exportId)) {
    throw new Error(`Definition of plugin "${name}" not found and may have failed to load.`);
  }
  const pluginExport = coreWindow.__kbnBundles__.get(exportId);
  if (typeof (pluginExport === null || pluginExport === void 0 ? void 0 : pluginExport.plugin) !== 'function') {
    throw new Error(`Definition of plugin "${name}" should be a function.`);
  } else {
    return pluginExport.plugin;
  }
}