"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _routes = require("../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _connector_view_search_indices_details = require("../shared/connector_view_search_indices_details/connector_view_search_indices_details");
var _connector_type = require("./connector_type");
var _encode_path_params = require("../shared/encode_path_params");
var _react_router_helpers = require("../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsTable = ({
  items,
  meta = {
    page: {
      from: 0,
      size: 10,
      total: 0
    }
  },
  onChange,
  isCrawler,
  isLoading,
  onDelete
}) => {
  const {
    services: {
      application
    }
  } = (0, _public.useKibana)();
  const columns = [...(!isCrawler ? [{
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.connectorName', {
      defaultMessage: 'Connector name'
    }),
    render: connector => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_PATH, {
        connectorId: connector.id
      })
    }, connector.name),
    width: '25%'
  }] : []), {
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.indexName', {
      defaultMessage: 'Index name'
    }),
    render: connector => connector.index_name ? connector.indexExists ? /*#__PURE__*/_react.default.createElement(_connector_view_search_indices_details.ConnectorViewIndexLink, {
      indexName: connector.index_name
    }) : connector.index_name : '--',
    width: isCrawler ? '70%' : '25%'
  }, {
    field: 'docsCount',
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.docsCount', {
      defaultMessage: 'Docs count'
    }),
    truncateText: true
  }, ...(!isCrawler ? [{
    field: 'service_type',
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.type', {
      defaultMessage: 'Connector type'
    }),
    render: serviceType => /*#__PURE__*/_react.default.createElement(_connector_type.ConnectorType, {
      serviceType: serviceType
    }),
    truncateText: true,
    width: '15%'
  }] : []), {
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.status', {
      defaultMessage: 'Ingestion status'
    }),
    render: connector => {
      const label = (0, _connector_status_helpers.connectorStatusToText)(connector);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: (0, _connector_status_helpers.connectorStatusToColor)(connector)
      }, label);
    },
    truncateText: true,
    width: '15%'
  }, {
    actions: [{
      description: 'Delete this connector',
      icon: 'trash',
      isPrimary: false,
      name: connector => _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.column.actions.deleteIndex', {
        defaultMessage: 'Delete connector {connectorName}',
        values: {
          connectorName: connector.name
        }
      }),
      onClick: connector => {
        onDelete(connector.name, connector.id, connector.index_name);
      },
      type: 'icon'
    }, {
      description: isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.actions.viewCrawler', {
        defaultMessage: 'View this crawler'
      }) : _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.actions.viewIndex', {
        defaultMessage: 'View this connector'
      }),
      enabled: connector => !!connector.index_name,
      icon: 'eye',
      isPrimary: false,
      name: connector => _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorsTable.columns.actions.viewIndex.caption', {
        defaultMessage: 'View index {connectorName}',
        values: {
          connectorName: connector.name
        }
      }),
      onClick: connector => {
        if (isCrawler) {
          // crawler always has an index this is to satisfy TS
          if (connector.index_name) {
            application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.SEARCH_INDEX_PATH}`, {
              indexName: connector.index_name
            }));
          }
        } else {
          application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_PATH}`, {
            connectorId: connector.id
          }));
        }
      },
      type: 'icon'
    }],
    name: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.connectorTable.columns.actions', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    onChange: onChange,
    tableLayout: "fixed",
    tableCaption: _i18n.i18n.translate('xpack.contentConnectorsTable.table.availableConnectorsTableCaption', {
      defaultMessage: 'Available connectors table'
    }),
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "aria-live": "polite",
      size: "s"
    }, _i18n.i18n.translate('xpack.contentConnectorsTable.table.noResultsMessage', {
      defaultMessage: 'No connectors found'
    })),
    pagination: {
      pageIndex: meta.page.from / (meta.page.size || 1),
      pageSize: meta.page.size,
      showPerPageOptions: false,
      totalItemCount: meta.page.total
    }
  })));
};
exports.ConnectorsTable = ConnectorsTable;