"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignments = Assignments;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _assignment = require("../assignment/assignment");
var _color_mapping = require("../../state/color_mapping");
var _selectors = require("../../state/selectors");
var _color_assignment_matcher = require("../../color/color_assignment_matcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Assignments({
  data,
  palettes,
  isDarkMode,
  specialTokens,
  formatter,
  allowCustomMatch
}) {
  const [showOtherActions, setShowOtherActions] = (0, _react2.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(palettes));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const assignments = (0, _reactRedux.useSelector)(_selectors.selectComputedAssignments);
  const assignmentMatcher = (0, _react2.useMemo)(() => (0, _color_assignment_matcher.getColorAssignmentMatcher)(assignments), [assignments]);
  const unmatchingCategories = (0, _react2.useMemo)(() => {
    return data.type === 'categories' ? data.categories.filter(category => {
      const rawValue = (0, _common.deserializeField)(category);
      return !assignmentMatcher.hasMatch(rawValue);
    }) : [];
  }, [data, assignmentMatcher]);
  const onClickAddNewAssignment = (0, _react2.useCallback)(() => {
    const lastCategorical = assignments.findLast(a => {
      return a.color.type === 'categorical';
    });
    const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
    dispatch((0, _color_mapping.addNewAssignment)({
      rules: [],
      color: colorMode.type === 'categorical' ? {
        type: 'categorical',
        paletteId: palette.id,
        colorIndex: nextCategoricalIndex % palette.colors().length
      } : {
        type: 'gradient'
      },
      touched: false
    }));
  }, [assignments, colorMode.type, dispatch, palette]);
  const onClickAddAllCurrentCategories = (0, _react2.useCallback)(() => {
    if (data.type === 'categories') {
      const lastCategorical = (0, _lodash.findLast)(assignments, d => {
        return d.color.type === 'categorical';
      });
      const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
      const newAssignments = unmatchingCategories.map((category, i) => {
        return {
          rules: [{
            type: 'raw',
            value: category
          }],
          color: colorMode.type === 'categorical' ? {
            type: 'categorical',
            paletteId: palette.id,
            colorIndex: (nextCategoricalIndex + i) % palette.colors().length
          } : {
            type: 'gradient'
          },
          touched: false
        };
      });
      dispatch((0, _color_mapping.addNewAssignments)(newAssignments));
    }
  }, [data.type, assignments, unmatchingCategories, dispatch, colorMode.type, palette]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "m",
    hasShadow: false,
    paddingSize: "none",
    css: (0, _react.css)`
        overflow: hidden;
      `
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingSmall};
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "lns-colorMapping-assignmentsList"
  }, assignments.map((assignment, i) => {
    return /*#__PURE__*/_react2.default.createElement(_assignment.Assignment, {
      key: i,
      data: data,
      index: i,
      assignments: assignments,
      colorMode: colorMode,
      palette: palette,
      palettes: palettes,
      isDarkMode: isDarkMode,
      assignment: assignment,
      disableDelete: false,
      specialTokens: specialTokens,
      formatter: formatter,
      allowCustomMatch: allowCustomMatch,
      assignmentMatcher: assignmentMatcher
    });
  }), assignments.length === 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    paddingSize: "s",
    "data-test-subj": "lns-colorMapping-assignmentsPrompt",
    body: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react2.default.createElement("p", null, _i18n.i18n.translate('coloring.colorMapping.container.mapValuesPromptDescription.mapValuesPromptDetail', {
      defaultMessage: 'Add a new assignment to manually associate terms with specified colors.'
    }))),
    actions: [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "primary",
      size: "s",
      onClick: onClickAddNewAssignment,
      iconType: "plus"
    }, _i18n.i18n.translate('coloring.colorMapping.container.AddAssignmentButtonLabel', {
      defaultMessage: 'Add assignment'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lns-colorMapping-assignmentsPromptAddAll",
      size: "xs",
      onClick: onClickAddAllCurrentCategories
    }, _i18n.i18n.translate('coloring.colorMapping.container.mapValueButtonLabel', {
      defaultMessage: 'Add all unassigned terms'
    }))]
  }))), assignments.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), assignments.length > 0 && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingSmall};
            overflow: hidden;
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    onClick: onClickAddNewAssignment,
    iconType: "plus"
  }, _i18n.i18n.translate('coloring.colorMapping.container.AddAssignmentButtonLabel', {
    defaultMessage: 'Add assignment'
  })), data.type === 'categories' && /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      color: "text",
      "aria-label": _i18n.i18n.translate('coloring.colorMapping.container.OpenAdditionalActionsButtonLabel', {
        defaultMessage: 'Open additional assignments actions'
      }),
      onClick: () => setShowOtherActions(true)
    }),
    isOpen: showOtherActions,
    closePopover: () => setShowOtherActions(false),
    panelPaddingSize: "xs",
    anchorPosition: "downRight",
    ownFocus: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "lns-colorMapping-addAllAssignments",
      key: "item-1",
      icon: "listAdd",
      size: "s",
      onClick: () => {
        setShowOtherActions(false);
        requestAnimationFrame(() => {
          onClickAddAllCurrentCategories();
        });
      },
      disabled: unmatchingCategories.length === 0
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('coloring.colorMapping.container.mapCurrentValuesButtonLabel', {
      defaultMessage: 'Add all unsassigned terms'
    })), unmatchingCategories.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 0
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued"
    }, unmatchingCategories.length)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "lns-colorMapping-clearAllAssignments",
      size: "s",
      icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "eraser",
        size: "m",
        color: "danger"
      }),
      onClick: () => {
        setShowOtherActions(false);
        dispatch((0, _color_mapping.removeAllAssignments)());
      },
      css: (0, _react.css)`
                        color: ${_uiTheme.euiThemeVars.euiColorDanger};
                      `
    }, _i18n.i18n.translate('coloring.colorMapping.container.clearAllAssignmentsButtonLabel', {
      defaultMessage: 'Clear all assignments'
    }))]
  })))));
}