"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCAIBackfillTask = registerCAIBackfillTask;
exports.scheduleCAIBackfillTask = scheduleCAIBackfillTask;
var _constants = require("../../../../common/constants");
var _backfill_task_factory = require("./backfill_task_factory");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCAIBackfillTask({
  taskManager,
  logger,
  core,
  analyticsConfig
}) {
  const getESClient = async () => {
    const [{
      elasticsearch
    }] = await core.getStartServices();
    return elasticsearch.client.asInternalUser;
  };
  taskManager.registerTaskDefinitions({
    [_constants.ANALYTICS_BACKFILL_TASK_TYPE]: {
      title: 'Backfill cases analytics indexes.',
      maxAttempts: 3,
      createTaskRunner: context => {
        return new _backfill_task_factory.CaseAnalyticsIndexBackfillTaskFactory({
          getESClient,
          logger,
          analyticsConfig
        }).create(context);
      }
    }
  });
}
async function scheduleCAIBackfillTask({
  taskId,
  sourceIndex,
  sourceQuery,
  destIndex,
  taskManager,
  logger
}) {
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: _constants.ANALYTICS_BACKFILL_TASK_TYPE,
      params: {
        sourceIndex,
        destIndex,
        sourceQuery
      },
      runAt: new Date(Date.now() + _constants2.BACKFILL_RUN_AT),
      // todo, value is short for testing but should run after 5 minutes
      state: {}
    });
  } catch (e) {
    logger.error(`Error scheduling ${taskId} task, received ${e.message}`);
  }
}