"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tryToRemoveTasks = void 0;
var _apmUtils = require("@kbn/apm-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tryToRemoveTasks = async ({
  taskIdsToDelete,
  logger,
  taskManager
}) => {
  const taskIdsFailedToBeDeleted = [];
  const taskIdsSuccessfullyDeleted = [];
  return await (0, _apmUtils.withSpan)({
    name: 'taskManager.bulkRemove',
    type: 'rules'
  }, async () => {
    if (taskIdsToDelete.length > 0) {
      try {
        const resultFromDeletingTasks = await taskManager.bulkRemove(taskIdsToDelete);
        resultFromDeletingTasks === null || resultFromDeletingTasks === void 0 ? void 0 : resultFromDeletingTasks.statuses.forEach(status => {
          var _status$error;
          if (status.success || ((_status$error = status.error) === null || _status$error === void 0 ? void 0 : _status$error.statusCode) === 404) {
            taskIdsSuccessfullyDeleted.push(status.id);
          } else {
            taskIdsFailedToBeDeleted.push(status.id);
          }
        });
        if (taskIdsSuccessfullyDeleted.length) {
          logger.debug(`Successfully deleted schedules for underlying tasks: ${taskIdsSuccessfullyDeleted.join(', ')}`);
        }
        if (taskIdsFailedToBeDeleted.length) {
          logger.error(`Failure to delete schedules for underlying tasks: ${taskIdsFailedToBeDeleted.join(', ')}`);
        }
      } catch (error) {
        logger.error(`Failure to delete schedules for underlying tasks: ${taskIdsToDelete.join(', ')}. TaskManager bulkRemove failed with Error: ${error.message}`);
      }
    }
    return taskIdsFailedToBeDeleted;
  });
};
exports.tryToRemoveTasks = tryToRemoveTasks;