"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyButton = exports.COPY_ARIA_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPY_ARIA_LABEL = exports.COPY_ARIA_LABEL = _i18n.i18n.translate('xpack.csp.clipboard.copy', {
  defaultMessage: 'Copy'
});
const CopyButton = ({
  copyText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: copyText
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  "aria-label": COPY_ARIA_LABEL,
  iconType: "copy",
  onClick: copy
}));
exports.CopyButton = CopyButton;