"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTagsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_get_tags = require("../../../containers/use_get_tags");
var _edit_tags_selectable = require("./edit_tags_selectable");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBodyCss = (0, _react2.css)`
  ${(0, _eui.euiFullHeight)()}

  .euiFlyoutBody__overflowContent {
    ${(0, _eui.euiFullHeight)()}
  }
`;
const EditTagsFlyoutComponent = ({
  selectedCases,
  onClose,
  onSaveTags
}) => {
  const {
    data: tags,
    isLoading
  } = (0, _use_get_tags.useGetTags)();
  const [tagsSelection, setTagsSelection] = (0, _react.useState)({
    selectedItems: [],
    unSelectedItems: []
  });
  const onSave = (0, _react.useCallback)(() => onSaveTags(tagsSelection), [onSaveTags, tagsSelection]);
  const headerSubtitle = selectedCases.length > 1 ? i18n.SELECTED_CASES(selectedCases.length) : selectedCases[0].title;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "cases-edit-tags-flyout",
    "data-test-subj": "cases-edit-tags-flyout",
    size: "s",
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "cases-edit-tags-flyout-title"
  }, i18n.EDIT_TAGS)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, headerSubtitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: FlyoutBodyCss
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_edit_tags_selectable.EditTagsSelectable, {
    selectedCases: selectedCases,
    isLoading: isLoading,
    tags: tags !== null && tags !== void 0 ? tags : [],
    onChangeTags: setTagsSelection
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "cases-edit-tags-flyout-cancel"
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    "data-test-subj": "cases-edit-tags-flyout-submit"
  }, i18n.SAVE_SELECTION)))));
};
EditTagsFlyoutComponent.displayName = 'EditTagsFlyout';
const EditTagsFlyout = exports.EditTagsFlyout = /*#__PURE__*/_react.default.memo(EditTagsFlyoutComponent);