"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentKeys = AgentKeys;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _permission_denied = require("./prompts/permission_denied");
var _api_keys_not_enabled = require("./prompts/api_keys_not_enabled");
var _agent_keys_table = require("./agent_keys_table");
var _create_agent_key = require("./create_agent_key");
var _agent_key_callout = require("./create_agent_key/agent_key_callout");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DATA = {
  areApiKeysEnabled: false,
  canManage: false
};
function AgentKeys() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    toasts
  } = core.notifications;
  const canSave = core.application.capabilities.apm['settings:save'];
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [createdAgentKey, setCreatedAgentKey] = (0, _react.useState)();
  const {
    data: {
      areApiKeysEnabled,
      canManage: canManageAgentKeys
    } = INITIAL_DATA,
    status: privilegesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/agent_keys/privileges');
  }, [], {
    showToastOnError: false
  });
  const {
    data,
    status,
    refetch: refetchAgentKeys
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (areApiKeysEnabled && canManageAgentKeys) {
      return callApmApi('GET /internal/apm/agent_keys');
    }
  }, [areApiKeysEnabled, canManageAgentKeys], {
    showToastOnError: false
  });
  const canManage = canManageAgentKeys && canSave;
  const agentKeys = data === null || data === void 0 ? void 0 : data.agentKeys;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.title', {
    defaultMessage: 'APM agent keys'
  })))), areApiKeysEnabled && canManage && !(0, _lodash.isEmpty)(agentKeys) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmAgentKeysCreateApmAgentKeyButton",
    onClick: () => setIsFlyoutVisible(true),
    fill: true,
    iconType: "plusInCircle"
  }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.createAgentKeyButton', {
    defaultMessage: 'Create APM agent key'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.descriptionText', {
    defaultMessage: 'View and delete APM agent keys. An APM agent key sends requests on behalf of a user.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), createdAgentKey && /*#__PURE__*/_react.default.createElement(_agent_key_callout.AgentKeyCallOut, {
    name: createdAgentKey.name,
    token: btoa(`${createdAgentKey.id}:${createdAgentKey.api_key}`)
  }), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_create_agent_key.CreateAgentKeyFlyout, {
    onCancel: () => {
      setIsFlyoutVisible(false);
    },
    onSuccess: agentKey => {
      setCreatedAgentKey(agentKey);
      setIsFlyoutVisible(false);
      refetchAgentKeys();
    },
    onError: (keyName, message) => {
      toasts.addDanger(_i18n.i18n.translate('xpack.apm.settings.agentKeys.crate.failed', {
        defaultMessage: 'Error creating APM agent key "{keyName}". Error: "{message}"',
        values: {
          keyName,
          message
        }
      }));
      setIsFlyoutVisible(false);
    }
  }), /*#__PURE__*/_react.default.createElement(AgentKeysContent, {
    loading: privilegesStatus === _use_fetcher.FETCH_STATUS.LOADING || status === _use_fetcher.FETCH_STATUS.LOADING,
    requestFailed: privilegesStatus === _use_fetcher.FETCH_STATUS.FAILURE || status === _use_fetcher.FETCH_STATUS.FAILURE,
    canManage: canManage,
    areApiKeysEnabled: areApiKeysEnabled,
    agentKeys: agentKeys,
    onKeyDelete: () => {
      setCreatedAgentKey(undefined);
      refetchAgentKeys();
    },
    onCreateAgentClick: () => setIsFlyoutVisible(true)
  }));
}
function AgentKeysContent({
  loading,
  requestFailed,
  canManage,
  areApiKeysEnabled,
  agentKeys,
  onKeyDelete,
  onCreateAgentClick
}) {
  if (!agentKeys) {
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "xl"
        }),
        titleSize: "xs",
        title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.agentKeysLoadingPromptTitle', {
          defaultMessage: 'Loading APM agent keys...'
        }))
      });
    }
    if (requestFailed) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "warning",
        title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.agentKeysErrorPromptTitle', {
          defaultMessage: 'Could not load APM agent keys.'
        }))
      });
    }
    if (!canManage) {
      return /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, null);
    }
    if (!areApiKeysEnabled) {
      return /*#__PURE__*/_react.default.createElement(_api_keys_not_enabled.ApiKeysNotEnabled, null);
    }
  }
  if (agentKeys && (0, _lodash.isEmpty)(agentKeys)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "gear",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.emptyPromptTitle', {
        defaultMessage: 'Create your first key'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.agentKeys.emptyPromptBody', {
        defaultMessage: 'Create APM agent keys to authorize APM agent requests to the ingest endpoint.'
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: !canManage && _i18n.i18n.translate('xpack.apm.settings.agentKeys.noPermissionCreateAgentKeyTooltipLabel', {
          defaultMessage: "Your user role doesn't have permissions to create agent keys."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "apmAgentKeysContentCreateApmAgentKeyButton",
        onClick: onCreateAgentClick,
        fill: true,
        iconType: "plusInCircle",
        isDisabled: !canManage
      }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.createAgentKeyButton', {
        defaultMessage: 'Create APM agent key'
      })))
    });
  }
  if (agentKeys && !(0, _lodash.isEmpty)(agentKeys)) {
    return /*#__PURE__*/_react.default.createElement(_agent_keys_table.AgentKeysTable, {
      agentKeys: agentKeys !== null && agentKeys !== void 0 ? agentKeys : [],
      canManage: canManage,
      onKeyDelete: onKeyDelete
    });
  }
  return null;
}