"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenKnownApmEventFields = unflattenKnownApmEventFields;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _merge_plain_objects = require("@kbn/observability-utils-common/object/merge_plain_objects");
var _utility_types = require("./utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function unflattenKnownApmEventFields(hitFields, requiredFields) {
  if (!hitFields) {
    return undefined;
  }
  if (requiredFields) {
    (0, _utility_types.ensureRequiredApmFields)(hitFields, requiredFields);
  }

  // Merging still required in order to have correct overriding of known fields over unknown ones
  const unflattened = (0, _merge_plain_objects.mergePlainObjects)(...unflattenSingleOrMultiValueFields(hitFields));
  return unflattened;
}
function unflattenSingleOrMultiValueFields(fields) {
  return Object.entries(fields).reduce((mappedFields, [field, value]) => {
    const [unknownFields, knownFields] = mappedFields;
    if (value != null) {
      if (_utility_types.ALL_FIELDS.has(field)) {
        const mappedValue = _utility_types.KNOWN_SINGLE_VALUED_FIELDS_SET.has(field) && Array.isArray(value) ? value[0] : value;
        (0, _saferLodashSet.set)(knownFields, field, mappedValue);
      } else {
        (0, _saferLodashSet.set)(unknownFields, field, value);
      }
    }
    return mappedFields;
  }, [{}, {}]);
}