"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securitySolutionSetting = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _ai_assistant_type = require("../../../common/ai_assistant_type");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Define the securitySolutionSetting with proper typing
const securitySolutionSetting = exports.securitySolutionSetting = {
  name: _translations.TITLE,
  description: _i18n.i18n.translate('aiAssistantManagementSelection.securitySolutionSetting.preferredAIAssistantTypeSettingDescription', {
    defaultMessage: 'Choose if the Security AI Assistant is available. Show the Security AI Assistant, or hide the Assistant entirely.'
  }),
  schema: _configSchema.schema.oneOf([_configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Security), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Never)], {
    defaultValue: _ai_assistant_type.AIAssistantType.Security
  }),
  options: [_ai_assistant_type.AIAssistantType.Security, _ai_assistant_type.AIAssistantType.Never],
  type: 'select',
  optionLabels: {
    [_ai_assistant_type.AIAssistantType.Security]: _translations.SHOW_SECURITY,
    [_ai_assistant_type.AIAssistantType.Never]: _translations.HIDE_ASSISTANT
  },
  requiresPageReload: true,
  solution: 'security'
};