"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonEmptyStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _button_display = require("../button_display/_button_display.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiButtonEmptyStyles = exports.euiButtonEmptyStyles = function euiButtonEmptyStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'buttonVariant');

  // EuiButtonEmpty uses the same size/font styling as EuiButtonDisplay,
  // but does not share enough of the same colors/props to the point
  // of using the actual component - so we'll reuse its styles instead
  var displayStyles = (0, _button_display.euiButtonDisplayStyles)(euiThemeContext);
  var refreshFlushStyles = "\n      /* using duplicate selector to ensure specificity */\n      &&:hover,\n      &&:active {\n        background-color: transparent;\n\n        /* removes hover overlay */\n        &::before {\n          display: none;\n        }\n      }\n\n      &:hover:not(:disabled),\n      &:focus {\n        text-decoration: underline;\n\n        ".concat((0, _global_styling.highContrastModeStyles)(euiThemeContext, {
    forced: "\n            /* hides HCM hover border, flush buttons use text-decoration */\n            &::after {\n              display: none;\n            }\n          "
  }), "\n      }\n  ");
  return {
    euiButtonEmpty: /*#__PURE__*/(0, _react.css)(displayStyles.euiButtonDisplay, " ", (0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(euiTheme.size.s)), _global_styling.euiCanAnimate, "{transition-timing-function:ease-in;transition-duration:", euiTheme.animation.fast, ";};label:euiButtonEmpty;"),
    isDisabled: displayStyles.isDisabled,
    // Sizes
    xs: displayStyles.xs,
    s: displayStyles.s,
    // uses array here to prevent adding duplicate "m" classname partial
    m: [displayStyles.m, isRefreshVariant && "\n        ".concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), "\n      ")],
    // Flush sides
    flush: /*#__PURE__*/(0, _react.css)("padding-inline:0;", isRefreshVariant && refreshFlushStyles, ";;label:flush;"),
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), ";;label:left;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";;label:right;"),
    both: /*#__PURE__*/(0, _react.css)(";label:both;")
  };
};