/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.util.Objects;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.elasticsearch.search.vectors.DiversifiedIVFKnnCollectorManager;
import org.elasticsearch.search.vectors.IVFKnnFloatVectorQuery;

public class DiversifyingChildrenIVFKnnFloatVectorQuery
extends IVFKnnFloatVectorQuery {
    private final BitSetProducer parentsFilter;

    public DiversifyingChildrenIVFKnnFloatVectorQuery(String field, float[] query, int k, int numCands, Query childFilter, BitSetProducer parentsFilter, int nProbe) {
        super(field, query, k, numCands, childFilter, nProbe);
        this.parentsFilter = parentsFilter;
    }

    @Override
    protected KnnCollectorManager getKnnCollectorManager(int k, IndexSearcher searcher) {
        return new DiversifiedIVFKnnCollectorManager(k, this.parentsFilter);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiversifyingChildrenIVFKnnFloatVectorQuery that = (DiversifyingChildrenIVFKnnFloatVectorQuery)o;
        return Objects.equals(this.parentsFilter, that.parentsFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentsFilter);
    }
}

