/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.scanner;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.plugin.Extensible;
import org.elasticsearch.plugin.NamedComponent;
import org.elasticsearch.plugin.scanner.ClassReaders;
import org.elasticsearch.plugin.scanner.ClassScanner;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class NamedComponentScanner {
    public static void main(String[] args) throws IOException {
        List<ClassReader> classReaders = ClassReaders.ofClassPath();
        Map<String, Map<String, String>> namedComponentsMap = NamedComponentScanner.scanForNamedClasses(classReaders);
        Path outputFile = Path.of(args[0], new String[0]);
        NamedComponentScanner.writeToFile(namedComponentsMap, outputFile);
    }

    public static void writeToFile(Map<String, Map<String, String>> namedComponentsMap, Path outputFile) throws IOException {
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);
             XContentBuilder namedComponents = XContentFactory.jsonBuilder((OutputStream)outputStream);){
            namedComponents.startObject();
            for (Map.Entry<String, Map<String, String>> extensibleToComponents : namedComponentsMap.entrySet()) {
                namedComponents.startObject(extensibleToComponents.getKey());
                for (Map.Entry<String, String> components : extensibleToComponents.getValue().entrySet()) {
                    namedComponents.field(components.getKey(), components.getValue());
                }
                namedComponents.endObject();
            }
            namedComponents.endObject();
        }
    }

    public static Map<String, Map<String, String>> scanForNamedClasses(List<ClassReader> classReaders) {
        ClassScanner extensibleClassScanner = new ClassScanner(Type.getDescriptor(Extensible.class), (classname, map) -> {
            map.put(classname, classname);
            return null;
        });
        extensibleClassScanner.visit(classReaders);
        ClassScanner namedComponentsScanner = new ClassScanner(Type.getDescriptor(NamedComponent.class), (classname, map) -> new AnnotationVisitor(589824, (Map)map, (String)classname){
            final /* synthetic */ Map val$map;
            final /* synthetic */ String val$classname;
            {
                this.val$map = map;
                this.val$classname = string;
                super(arg0);
            }

            public void visit(String key, Object value) {
                assert (key.equals("value"));
                assert (value instanceof String);
                this.val$map.put(value.toString(), this.val$classname);
            }
        });
        namedComponentsScanner.visit(classReaders);
        HashMap<String, Map<String, String>> componentInfo = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> e : namedComponentsScanner.getFoundClasses().entrySet()) {
            String name = e.getKey();
            String classnameWithSlashes = e.getValue();
            String extensibleClassnameWithSlashes = extensibleClassScanner.getFoundClasses().get(classnameWithSlashes);
            if (extensibleClassnameWithSlashes == null) {
                throw new RuntimeException("Named component " + name + "(" + NamedComponentScanner.pathToClassName(classnameWithSlashes) + ") does not extend from an extensible class");
            }
            Map named = componentInfo.computeIfAbsent(NamedComponentScanner.pathToClassName(extensibleClassnameWithSlashes), k -> new HashMap());
            named.put(name, NamedComponentScanner.pathToClassName(classnameWithSlashes));
        }
        return componentInfo;
    }

    private static String pathToClassName(String classWithSlashes) {
        return classWithSlashes.replace('/', '.');
    }
}

