/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract sealed class IntOrLongMatcher<T>
extends BaseMatcher<T> {
    public static IntOrLongMatcher<Integer> matches(int expected) {
        return new IntMatcher(expected);
    }

    public static IntOrLongMatcher<Long> matches(long expected) {
        return new LongMatcher(expected);
    }

    public static Matcher<Object> isIntOrLong() {
        return Matchers.anyOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.isA(Long.class));
    }

    private static final class IntMatcher
    extends IntOrLongMatcher<Integer> {
        private final int expected;

        private IntMatcher(int expected) {
            this.expected = expected;
        }

        public boolean matches(Object o) {
            Object object = o;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class}, (Object)object2, n)) {
                case 0 -> {
                    Integer i = (Integer)object2;
                    if (this.expected == i) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    Long l = (Long)object2;
                    if ((long)this.expected == l) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public void describeTo(Description description) {
            Matchers.equalTo((Object)this.expected).describeTo(description);
        }
    }

    private static final class LongMatcher
    extends IntOrLongMatcher<Long> {
        private final long expected;

        LongMatcher(long expected) {
            this.expected = expected;
        }

        public boolean matches(Object o) {
            Object object = o;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class}, (Object)object2, n)) {
                case 0 -> {
                    Integer i = (Integer)object2;
                    if (this.expected == (long)i.intValue()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    Long l = (Long)object2;
                    if (this.expected == l) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public void describeTo(Description description) {
            Matchers.equalTo((Object)this.expected).describeTo(description);
        }
    }
}

