/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class BreakerTestUtil {
    private static final Logger logger = LogManager.getLogger(BreakerTestUtil.class);

    public static <E extends Exception> ByteSizeValue findBreakerLimit(ByteSizeValue tooBigToBreak, CheckedConsumer<ByteSizeValue, E> c) throws E {
        try {
            c.accept((Object)tooBigToBreak);
        }
        catch (CircuitBreakingException e) {
            throw new IllegalArgumentException("expected runnable *not* to break under tooBigToBreak", e);
        }
        try {
            c.accept((Object)ByteSizeValue.ofBytes((long)0L));
            throw new IllegalArgumentException("expected runnable to break under a limit of 0 bytes");
        }
        catch (CircuitBreakingException e) {
            long l = BreakerTestUtil.findBreakerLimit(0L, tooBigToBreak.getBytes(), c);
            ByteSizeValue limit = ByteSizeValue.ofBytes((long)l);
            ByteSizeValue onePastLimit = ByteSizeValue.ofBytes((long)(l + 1L));
            try {
                c.accept((Object)limit);
                throw new IllegalArgumentException("expected runnable to break under a limit of " + String.valueOf(limit) + " bytes");
            }
            catch (CircuitBreakingException circuitBreakingException) {
                try {
                    c.accept((Object)onePastLimit);
                }
                catch (CircuitBreakingException e2) {
                    throw new IllegalArgumentException("expected runnable to *not* break under a limit of " + String.valueOf(onePastLimit) + " bytes");
                }
                return limit;
            }
        }
    }

    private static <E extends Exception> long findBreakerLimit(long min, long max, CheckedConsumer<ByteSizeValue, E> c) throws E {
        while (max - min > 1L) {
            assert (max > min);
            long diff = max - min;
            logger.info("Between {} and {}. {} bytes remaining.", new Object[]{ByteSizeValue.ofBytes((long)min), ByteSizeValue.ofBytes((long)max), ByteSizeValue.ofBytes((long)diff)});
            long mid = min + diff / 2L;
            try {
                c.accept((Object)ByteSizeValue.ofBytes((long)mid));
                max = mid;
            }
            catch (CircuitBreakingException e) {
                min = mid;
            }
        }
        return min;
    }
}

