/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class QueryRoleResponse
extends ActionResponse
implements ToXContentObject {
    public static final QueryRoleResponse EMPTY = new QueryRoleResponse(0L, List.of());
    private final long total;
    private final List<Item> foundRoleDescriptors;

    public QueryRoleResponse(long total, List<Item> foundRoleDescriptors) {
        this.total = total;
        Objects.requireNonNull(foundRoleDescriptors, "found_role_descriptor must be provided");
        this.foundRoleDescriptors = foundRoleDescriptors;
    }

    public long getTotal() {
        return this.total;
    }

    public List<Item> getRoleDescriptors() {
        return this.foundRoleDescriptors;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("total", this.total).field("count", this.foundRoleDescriptors.size()).field("roles", (Iterable<?>)this.foundRoleDescriptors);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRoleResponse that = (QueryRoleResponse)o;
        return this.total == that.total && Objects.equals(this.foundRoleDescriptors, that.foundRoleDescriptors);
    }

    public int hashCode() {
        int result = Objects.hash(this.total);
        result = 31 * result + Objects.hash(this.foundRoleDescriptors);
        return result;
    }

    public String toString() {
        return "QueryRoleResponse{total=" + this.total + ", items=" + String.valueOf(this.foundRoleDescriptors) + "}";
    }

    public record QueryRoleResult(long total, List<Item> items) {
        public static final QueryRoleResult EMPTY = new QueryRoleResult(0L, List.of());
    }

    public record Item(RoleDescriptor roleDescriptor, @Nullable Object[] sortValues) implements ToXContentObject
    {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            assert (!Strings.isNullOrEmpty(this.roleDescriptor.getName()));
            builder.field("name", this.roleDescriptor.getName());
            this.roleDescriptor.innerToXContent(builder, params, false);
            if (this.sortValues != null && this.sortValues.length > 0) {
                builder.array("_sort", this.sortValues);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return "Item{roleDescriptor=" + String.valueOf(this.roleDescriptor) + ", sortValues=" + Arrays.toString(this.sortValues) + "}";
        }
    }
}

