/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class SecurityFeatureSetUsage
extends XPackFeatureUsage {
    private static final String REALMS_XFIELD = "realms";
    private static final String ROLES_XFIELD = "roles";
    private static final String ROLE_MAPPING_XFIELD = "role_mapping";
    private static final String SSL_XFIELD = "ssl";
    private static final String TOKEN_SERVICE_XFIELD = "token_service";
    private static final String API_KEY_SERVICE_XFIELD = "api_key_service";
    private static final String AUDIT_XFIELD = "audit";
    private static final String IP_FILTER_XFIELD = "ipfilter";
    private static final String ANONYMOUS_XFIELD = "anonymous";
    private static final String FIPS_140_XFIELD = "fips_140";
    private static final String OPERATOR_PRIVILEGES_XFIELD = "operator_privileges";
    private static final String DOMAINS_XFIELD = "domains";
    private static final String USER_PROFILE_XFIELD = "user_profile";
    private static final String REMOTE_CLUSTER_SERVER_XFIELD = "remote_cluster_server";
    private Map<String, Object> realmsUsage;
    private Map<String, Object> rolesStoreUsage;
    private Map<String, Object> sslUsage;
    private Map<String, Object> tokenServiceUsage;
    private Map<String, Object> apiKeyServiceUsage;
    private Map<String, Object> auditUsage;
    private Map<String, Object> ipFilterUsage;
    private Map<String, Object> anonymousUsage;
    private Map<String, Object> roleMappingStoreUsage;
    private Map<String, Object> fips140Usage;
    private Map<String, Object> operatorPrivilegesUsage;
    private Map<String, Object> domainsUsage;
    private Map<String, Object> userProfileUsage;
    private Map<String, Object> remoteClusterServerUsage;

    public SecurityFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.realmsUsage = in.readGenericMap();
        this.rolesStoreUsage = in.readGenericMap();
        this.sslUsage = in.readGenericMap();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_2_0)) {
            this.tokenServiceUsage = in.readGenericMap();
            this.apiKeyServiceUsage = in.readGenericMap();
        }
        this.auditUsage = in.readGenericMap();
        this.ipFilterUsage = in.readGenericMap();
        this.anonymousUsage = in.readGenericMap();
        this.roleMappingStoreUsage = in.readGenericMap();
        this.fips140Usage = in.readGenericMap();
        this.operatorPrivilegesUsage = in.readGenericMap();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            this.domainsUsage = in.readGenericMap();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_5_0)) {
            this.userProfileUsage = in.readGenericMap();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            this.remoteClusterServerUsage = in.readGenericMap();
        }
    }

    public SecurityFeatureSetUsage(boolean enabled, Map<String, Object> realmsUsage, Map<String, Object> rolesStoreUsage, Map<String, Object> roleMappingStoreUsage, Map<String, Object> sslUsage, Map<String, Object> auditUsage, Map<String, Object> ipFilterUsage, Map<String, Object> anonymousUsage, Map<String, Object> tokenServiceUsage, Map<String, Object> apiKeyServiceUsage, Map<String, Object> fips140Usage, Map<String, Object> operatorPrivilegesUsage, Map<String, Object> domainsUsage, Map<String, Object> userProfileUsage, Map<String, Object> remoteClusterServerUsage) {
        super("security", true, enabled);
        this.realmsUsage = realmsUsage;
        this.rolesStoreUsage = rolesStoreUsage;
        this.roleMappingStoreUsage = roleMappingStoreUsage;
        this.sslUsage = sslUsage;
        this.tokenServiceUsage = tokenServiceUsage;
        this.apiKeyServiceUsage = apiKeyServiceUsage;
        this.auditUsage = auditUsage;
        this.ipFilterUsage = ipFilterUsage;
        this.anonymousUsage = anonymousUsage;
        this.fips140Usage = fips140Usage;
        this.operatorPrivilegesUsage = operatorPrivilegesUsage;
        this.domainsUsage = domainsUsage;
        this.userProfileUsage = userProfileUsage;
        this.remoteClusterServerUsage = remoteClusterServerUsage;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericMap(this.realmsUsage);
        out.writeGenericMap(this.rolesStoreUsage);
        out.writeGenericMap(this.sslUsage);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_2_0)) {
            out.writeGenericMap(this.tokenServiceUsage);
            out.writeGenericMap(this.apiKeyServiceUsage);
        }
        out.writeGenericMap(this.auditUsage);
        out.writeGenericMap(this.ipFilterUsage);
        out.writeGenericMap(this.anonymousUsage);
        out.writeGenericMap(this.roleMappingStoreUsage);
        out.writeGenericMap(this.fips140Usage);
        out.writeGenericMap(this.operatorPrivilegesUsage);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            out.writeGenericMap(this.domainsUsage);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_5_0)) {
            out.writeGenericMap(this.userProfileUsage);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeGenericMap(this.remoteClusterServerUsage);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            builder.field(REALMS_XFIELD, this.realmsUsage);
            builder.field(ROLES_XFIELD, this.rolesStoreUsage);
            builder.field(ROLE_MAPPING_XFIELD, this.roleMappingStoreUsage);
            builder.field(SSL_XFIELD, this.sslUsage);
            builder.field(TOKEN_SERVICE_XFIELD, this.tokenServiceUsage);
            builder.field(API_KEY_SERVICE_XFIELD, this.apiKeyServiceUsage);
            builder.field(AUDIT_XFIELD, this.auditUsage);
            builder.field(IP_FILTER_XFIELD, this.ipFilterUsage);
            builder.field(ANONYMOUS_XFIELD, this.anonymousUsage);
            builder.field(FIPS_140_XFIELD, this.fips140Usage);
            builder.field(OPERATOR_PRIVILEGES_XFIELD, this.operatorPrivilegesUsage);
            if (this.domainsUsage != null && !this.domainsUsage.isEmpty()) {
                builder.field(DOMAINS_XFIELD, this.domainsUsage);
            }
            if (this.userProfileUsage != null && !this.userProfileUsage.isEmpty()) {
                builder.field(USER_PROFILE_XFIELD, this.userProfileUsage);
            }
            if (this.remoteClusterServerUsage != null && !this.remoteClusterServerUsage.isEmpty()) {
                builder.field(REMOTE_CLUSTER_SERVER_XFIELD, this.remoteClusterServerUsage);
            }
        } else if (!this.sslUsage.isEmpty()) {
            builder.field(SSL_XFIELD, this.sslUsage);
        }
    }

    public Map<String, Object> getRealmsUsage() {
        return Collections.unmodifiableMap(this.realmsUsage);
    }
}

