/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FinalizeJobExecutionAction
extends ActionType<AcknowledgedResponse> {
    public static final FinalizeJobExecutionAction INSTANCE = new FinalizeJobExecutionAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/finalize_job_execution";

    private FinalizeJobExecutionAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String[] jobIds;

        public Request(String[] jobIds) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.jobIds = jobIds;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobIds = in.readStringArray();
        }

        public String[] getJobIds() {
            return this.jobIds;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.jobIds);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

