/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.LongSummaryStatistics;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreSettings;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.DataStreamFeatureSetUsage;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;

public class DataStreamUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final DataStreamFailureStoreSettings dataStreamFailureStoreSettings;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;

    @Inject
    public DataStreamUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        super(XPackUsageFeatureAction.DATA_STREAMS.name(), transportService, clusterService, threadPool, actionFilters);
        this.dataStreamFailureStoreSettings = dataStreamFailureStoreSettings;
        this.globalRetentionSettings = globalRetentionSettings;
    }

    @Override
    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Map<String, DataStream> dataStreams = state.metadata().getProject().dataStreams();
        long backingIndicesCounter = 0L;
        long failureStoreExplicitlyEnabledCounter = 0L;
        long failureStoreEffectivelyEnabledCounter = 0L;
        long failureIndicesCounter = 0L;
        long failuresLifecycleExplicitlyEnabledCounter = 0L;
        long failuresLifecycleEffectivelyEnabledCounter = 0L;
        LongSummaryStatistics dataRetentionStats = new LongSummaryStatistics();
        LongSummaryStatistics effectiveRetentionStats = new LongSummaryStatistics();
        long affectedByMaxRetentionCounter = 0L;
        long affectedByDefaultRetentionCounter = 0L;
        DataStreamGlobalRetention globalRetention = this.globalRetentionSettings.get();
        for (DataStream ds : dataStreams.values()) {
            DataStreamLifecycle effectiveFailuresLifecycle;
            DataStreamLifecycle configuredFailuresLifecycle;
            boolean failureStoreEffectivelyEnabled;
            backingIndicesCounter += (long)ds.getIndices().size();
            if (ds.isFailureStoreExplicitlyEnabled()) {
                ++failureStoreExplicitlyEnabledCounter;
            }
            if (failureStoreEffectivelyEnabled = ds.isFailureStoreEffectivelyEnabled(this.dataStreamFailureStoreSettings)) {
                ++failureStoreEffectivelyEnabledCounter;
            }
            if (!ds.getFailureIndices().isEmpty()) {
                failureIndicesCounter += (long)ds.getFailureIndices().size();
            }
            DataStreamLifecycle dataStreamLifecycle = configuredFailuresLifecycle = ds.getDataStreamOptions() != null && ds.getDataStreamOptions().failureStore() != null && ds.getDataStreamOptions().failureStore().lifecycle() != null ? ds.getDataStreamOptions().failureStore().lifecycle() : null;
            if (configuredFailuresLifecycle != null && configuredFailuresLifecycle.enabled()) {
                ++failuresLifecycleExplicitlyEnabledCounter;
                if (configuredFailuresLifecycle.dataRetention() != null) {
                    dataRetentionStats.accept(configuredFailuresLifecycle.dataRetention().getMillis());
                }
            }
            if ((effectiveFailuresLifecycle = ds.getFailuresLifecycle(failureStoreEffectivelyEnabled)) == null || !effectiveFailuresLifecycle.enabled()) continue;
            ++failuresLifecycleEffectivelyEnabledCounter;
            Tuple<TimeValue, DataStreamLifecycle.RetentionSource> effectiveDataRetentionWithSource = effectiveFailuresLifecycle.getEffectiveDataRetentionWithSource(globalRetention, ds.isInternal());
            if (effectiveDataRetentionWithSource.v1() == null) continue;
            effectiveRetentionStats.accept(effectiveDataRetentionWithSource.v1().getMillis());
            if (effectiveDataRetentionWithSource.v2().equals((Object)DataStreamLifecycle.RetentionSource.MAX_GLOBAL_RETENTION)) {
                ++affectedByMaxRetentionCounter;
            }
            if (!effectiveDataRetentionWithSource.v2().equals((Object)DataStreamLifecycle.RetentionSource.DEFAULT_FAILURES_RETENTION)) continue;
            ++affectedByDefaultRetentionCounter;
        }
        DataStreamFeatureSetUsage.DataStreamStats stats = new DataStreamFeatureSetUsage.DataStreamStats(dataStreams.size(), backingIndicesCounter, failureStoreExplicitlyEnabledCounter, failureStoreEffectivelyEnabledCounter, failureIndicesCounter, failuresLifecycleExplicitlyEnabledCounter, failuresLifecycleEffectivelyEnabledCounter, DataStreamLifecycleFeatureSetUsage.RetentionStats.create(dataRetentionStats), DataStreamLifecycleFeatureSetUsage.RetentionStats.create(effectiveRetentionStats), DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats.getGlobalRetentionStats(globalRetention, affectedByDefaultRetentionCounter, affectedByMaxRetentionCounter));
        DataStreamFeatureSetUsage usage = new DataStreamFeatureSetUsage(stats);
        listener.onResponse(new XPackUsageFeatureResponse(usage));
    }
}

