/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.indices.DateFieldRangeInfo;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

public class TimestampFieldMapperService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(TimestampFieldMapperService.class);
    private final IndicesService indicesService;
    private final ExecutorService executor;
    private final Map<ProjectId, Map<Index, PlainActionFuture<DateFieldRangeInfo>>> fieldTypesByIndex = ConcurrentCollections.newConcurrentMap();

    public TimestampFieldMapperService(Settings settings, ThreadPool threadPool, IndicesService indicesService) {
        this.indicesService = indicesService;
        String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        String threadName = "TimestampFieldMapperService#updateTask";
        this.executor = EsExecutors.newScaling(nodeName + "/TimestampFieldMapperService#updateTask", 0, 1, 0L, TimeUnit.MILLISECONDS, true, EsExecutors.daemonThreadFactory(nodeName, "TimestampFieldMapperService#updateTask"), threadPool.getThreadContext());
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        ThreadPool.terminate(this.executor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        for (ProjectMetadata project : event.state().metadata().projects().values()) {
            ProjectMetadata previousProject = event.previousState().metadata().projects().get(project.id());
            if (previousProject != null && previousProject.indices() == project.indices()) continue;
            this.applyClusterStateForProject(project, this.fieldTypesByIndex.computeIfAbsent(project.id(), k -> ConcurrentCollections.newConcurrentMap()));
        }
        for (ProjectMetadata previousProject : event.previousState().metadata().projects().values()) {
            if (event.state().metadata().projects().containsKey(previousProject.id())) continue;
            this.fieldTypesByIndex.remove(previousProject.id());
        }
    }

    private void applyClusterStateForProject(ProjectMetadata project, Map<Index, PlainActionFuture<DateFieldRangeInfo>> fieldTypesByIndex) {
        Map<String, IndexMetadata> indices = project.indices();
        fieldTypesByIndex.keySet().removeIf(index -> !TimestampFieldMapperService.hasUsefulTimestampField(project.index((Index)index)));
        for (final IndexMetadata indexMetadata : indices.values()) {
            final Index index2 = indexMetadata.getIndex();
            if (!TimestampFieldMapperService.hasUsefulTimestampField(indexMetadata) || fieldTypesByIndex.containsKey(index2)) continue;
            logger.trace("computing timestamp mapping for {}", (Object)index2);
            final PlainActionFuture<DateFieldRangeInfo> future = new PlainActionFuture<DateFieldRangeInfo>();
            fieldTypesByIndex.put(index2, future);
            IndexService indexService = this.indicesService.indexService(index2);
            if (indexService == null) {
                logger.trace("computing timestamp mapping for {} async", (Object)index2);
                this.executor.execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug(() -> Strings.format("failed to compute mapping for %s", index2), (Throwable)e);
                        future.onResponse(null);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        try (MapperService mapperService = TimestampFieldMapperService.this.indicesService.createIndexMapperServiceForValidation(indexMetadata);){
                            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                            logger.trace("computed timestamp field mapping for {}", (Object)index2);
                            future.onResponse(TimestampFieldMapperService.fromMapperService(mapperService));
                        }
                    }
                });
                continue;
            }
            logger.trace("computing timestamp mapping for {} using existing index service", (Object)index2);
            try {
                future.onResponse(TimestampFieldMapperService.fromMapperService(indexService.mapperService()));
            }
            catch (Exception e) {
                assert (false) : e;
                future.onResponse(null);
            }
        }
    }

    private static boolean hasUsefulTimestampField(IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            return false;
        }
        if (indexMetadata.hasTimeSeriesTimestampRange()) {
            return true;
        }
        IndexLongFieldRange timestampRange = indexMetadata.getTimestampRange();
        if (timestampRange.isComplete() && timestampRange != IndexLongFieldRange.UNKNOWN) {
            return true;
        }
        IndexLongFieldRange eventIngestedRange = indexMetadata.getEventIngestedRange();
        return eventIngestedRange.isComplete() && eventIngestedRange != IndexLongFieldRange.UNKNOWN;
    }

    private static DateFieldRangeInfo fromMapperService(MapperService mapperService) {
        DateFieldMapper.DateFieldType dateFieldType;
        DateFieldMapper.DateFieldType timestampFieldType = null;
        DateFieldMapper.DateFieldType eventIngestedFieldType = null;
        MappedFieldType mappedFieldType = mapperService.fieldType("@timestamp");
        if (mappedFieldType instanceof DateFieldMapper.DateFieldType && (dateFieldType = (DateFieldMapper.DateFieldType)mappedFieldType).name().equals("@timestamp")) {
            timestampFieldType = dateFieldType;
        }
        if ((mappedFieldType = mapperService.fieldType("event.ingested")) instanceof DateFieldMapper.DateFieldType && (dateFieldType = (DateFieldMapper.DateFieldType)mappedFieldType).name().equals("event.ingested")) {
            eventIngestedFieldType = dateFieldType;
        }
        if (timestampFieldType == null && eventIngestedFieldType == null) {
            return null;
        }
        return new DateFieldRangeInfo(timestampFieldType, null, eventIngestedFieldType, null);
    }

    @Nullable
    public DateFieldRangeInfo getTimestampFieldTypeInfo(Index index) {
        PlainActionFuture future = this.fieldTypesByIndex.values().stream().map(map -> (PlainActionFuture)map.get(index)).filter(Objects::nonNull).findFirst().orElse(null);
        if (future == null || !future.isDone()) {
            return null;
        }
        try {
            return (DateFieldRangeInfo)future.result();
        }
        catch (ExecutionException e) {
            throw new UncategorizedExecutionException("An error occurred fetching timestamp field type for " + String.valueOf(index), e);
        }
    }
}

