/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.plugins.internal.XContentParserDecorator;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.UpdateCtxMap;
import org.elasticsearch.script.UpdateMetadata;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.script.UpsertCtxMap;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentType;

public class UpdateHelper {
    private static final Logger logger = LogManager.getLogger(UpdateHelper.class);
    private final ScriptService scriptService;

    public UpdateHelper(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard, LongSupplier nowInMillis) throws IOException {
        return this.prepare(request, indexShard, nowInMillis, new String[]{"_routing"});
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard, LongSupplier nowInMillis, String[] gFields) throws IOException {
        GetResult getResult = indexShard.getService().getForUpdate(request.id(), request.ifSeqNo(), request.ifPrimaryTerm(), gFields);
        return this.prepare(indexShard, request, getResult, nowInMillis);
    }

    protected Result prepare(IndexShard indexShard, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        if (!getResult.isExists()) {
            return this.prepareUpsert(indexShard.shardId(), request, getResult, nowInMillis);
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(indexShard.shardId(), request.id());
        }
        if (request.script() == null && request.doc() != null) {
            return this.prepareUpdateIndexRequest(indexShard, request, getResult, request.detectNoop());
        }
        return this.prepareUpdateScriptRequest(indexShard, request, getResult, nowInMillis);
    }

    Tuple<UpdateOpType, Map<String, Object>> executeScriptedUpsert(Script script, UpsertCtxMap ctxMap) {
        UpdateOpType operation = UpdateOpType.lenientFromString(((UpdateMetadata)(ctxMap = this.executeScript(script, ctxMap)).getMetadata()).getOp(), logger, script.getIdOrCode());
        if (operation != UpdateOpType.CREATE && operation != UpdateOpType.NONE) {
            logger.warn("Invalid upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)script.getIdOrCode());
            operation = UpdateOpType.NONE;
        }
        return new Tuple<UpdateOpType, Map<String, Object>>(operation, ctxMap.getSource());
    }

    Result prepareUpsert(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        IndexRequest indexRequest;
        if (request.upsertRequest() == null && !request.docAsUpsert()) {
            throw new DocumentMissingException(shardId, request.id());
        }
        IndexRequest indexRequest2 = indexRequest = request.docAsUpsert() ? request.doc() : request.upsertRequest();
        if (request.scriptedUpsert() && request.script() != null) {
            IndexRequest upsert = request.upsertRequest();
            UpsertCtxMap ctxMap = new UpsertCtxMap(getResult.getIndex(), getResult.getId(), UpdateOpType.CREATE.toString(), nowInMillis.getAsLong(), upsert.sourceAsMap());
            Tuple<UpdateOpType, Map<String, Object>> upsertResult = this.executeScriptedUpsert(request.script, ctxMap);
            switch (upsertResult.v1().ordinal()) {
                case 0: {
                    String index = request.index();
                    indexRequest = new IndexRequest(index).source(upsertResult.v2());
                    break;
                }
                case 3: {
                    UpdateResponse update = new UpdateResponse(shardId, getResult.getId(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
                    update.setGetResult(getResult);
                    return new Result(update, DocWriteResponse.Result.NOOP, upsertResult.v2(), XContentType.JSON);
                }
                default: {
                    throw new IllegalArgumentException("unknown upsert operation, got: " + String.valueOf((Object)upsertResult.v1()));
                }
            }
        }
        ((IndexRequest)((IndexRequest)((IndexRequest)((IndexRequest)indexRequest.index(request.index())).id(request.id()).setRefreshPolicy(request.getRefreshPolicy())).routing(request.routing()).timeout(request.timeout())).waitForActiveShards(request.waitForActiveShards())).create(true);
        if (request.versionType() != VersionType.INTERNAL) {
            indexRequest.version(request.version()).versionType(request.versionType());
        }
        return new Result(indexRequest, DocWriteResponse.Result.CREATED, null, null);
    }

    @Nullable
    static String calculateRouting(GetResult getResult, @Nullable IndexRequest updateIndexRequest) {
        if (updateIndexRequest != null && updateIndexRequest.routing() != null) {
            return updateIndexRequest.routing();
        }
        if (getResult.getFields().containsKey("_routing")) {
            return getResult.field("_routing").getValue().toString();
        }
        return null;
    }

    Result prepareUpdateIndexRequest(IndexShard indexShard, UpdateRequest request, GetResult getResult, boolean detectNoop) {
        boolean noop;
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = sourceAndContent.v1();
        Map<String, Object> updatedSourceAsMap = sourceAndContent.v2();
        boolean bl = noop = !XContentHelper.update(updatedSourceAsMap, currentRequest.sourceAsMap(XContentParserDecorator.NOOP), detectNoop);
        if (detectNoop && noop) {
            UpdateResponse update = new UpdateResponse(indexShard.shardId(), getResult.getId(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
            update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), indexShard.mapperService().mappingLookup(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
            return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
        }
        String index = request.index();
        IndexRequest finalIndexRequest = (IndexRequest)((IndexRequest)((IndexRequest)new IndexRequest(index).id(request.id()).routing(routing).source(updatedSourceAsMap, updateSourceContentType).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
        return new Result(finalIndexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
    }

    Result prepareUpdateScriptRequest(IndexShard indexShard, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = sourceAndContent.v1();
        UpdateCtxMap ctxMap = this.executeScript(request.script, new UpdateCtxMap(getResult.getIndex(), getResult.getId(), getResult.getVersion(), routing, "_doc", UpdateOpType.INDEX.toString(), nowInMillis.getAsLong(), sourceAndContent.v2()));
        UpdateOpType operation = UpdateOpType.lenientFromString(((UpdateMetadata)ctxMap.getMetadata()).getOp(), logger, request.script.getIdOrCode());
        Map<String, Object> updatedSourceAsMap = ctxMap.getSource();
        switch (operation.ordinal()) {
            case 1: {
                String index = request.index();
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)((IndexRequest)new IndexRequest(index).id(request.id()).routing(routing).source(updatedSourceAsMap, updateSourceContentType).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(indexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
            }
            case 2: {
                String index = request.index();
                DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)((DeleteRequest)new DeleteRequest(index).id(request.id()).routing(routing).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(deleteRequest, DocWriteResponse.Result.DELETED, updatedSourceAsMap, updateSourceContentType);
            }
        }
        UpdateResponse update = new UpdateResponse(indexShard.shardId(), getResult.getId(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
        update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), indexShard.mapperService().mappingLookup(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
        return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
    }

    private <T extends UpdateCtxMap> T executeScript(Script script, T ctxMap) {
        try {
            if (this.scriptService != null) {
                UpdateScript.Factory factory = this.scriptService.compile(script, UpdateScript.CONTEXT);
                UpdateScript executableScript = factory.newInstance(script.getParams(), ctxMap);
                executableScript.execute();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to execute script", e);
        }
        return ctxMap;
    }

    public static GetResult extractGetResult(UpdateRequest request, String concreteIndex, MappingLookup mappingLookup, long seqNo, long primaryTerm, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (request.fetchSource() == null || !request.fetchSource().fetchSource()) {
            return null;
        }
        BytesReference sourceFilteredAsBytes = sourceAsBytes;
        SourceFilter sourceFilter = request.fetchSource().filter();
        if (sourceFilter != null) {
            sourceFilteredAsBytes = Source.fromMap(source, sourceContentType).filter(sourceFilter).internalSourceRef();
        }
        return new GetResult(concreteIndex, request.id(), seqNo, primaryTerm, version, true, sourceFilteredAsBytes, Collections.emptyMap(), Collections.emptyMap());
    }

    public static class Result {
        private final Writeable action;
        private final DocWriteResponse.Result result;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Writeable action, DocWriteResponse.Result result, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.result = result;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Writeable> T action() {
            return (T)this.action;
        }

        public DocWriteResponse.Result getResponseResult() {
            return this.result;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }

    static enum UpdateOpType {
        CREATE("create"),
        INDEX("index"),
        DELETE("delete"),
        NONE("none");

        private final String name;

        private UpdateOpType(String name) {
            this.name = name;
        }

        public static UpdateOpType lenientFromString(String operation, Logger logger, String scriptId) {
            switch (operation) {
                case "create": {
                    return CREATE;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
                case "noop": 
                case "none": {
                    return NONE;
                }
            }
            logger.warn("Used upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)scriptId);
            return NONE;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ContextFields {
        public static final String CTX = "ctx";
        public static final String OP = "op";
        public static final String SOURCE = "_source";
        public static final String NOW = "_now";
        public static final String INDEX = "_index";
        public static final String TYPE = "_type";
        public static final String ID = "_id";
        public static final String VERSION = "_version";
        public static final String ROUTING = "_routing";
    }
}

