/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteClusterAware;

public class ResolveClusterActionRequest
extends LegacyActionRequest
implements IndicesRequest.Replaceable {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
    public static final String TRANSPORT_VERSION_ERROR_MESSAGE_PREFIX = "ResolveClusterAction requires at least version";
    private String[] names;
    private boolean localIndicesRequested = false;
    private IndicesOptions indicesOptions;
    private TimeValue timeout;
    private final boolean clusterInfoOnly;
    private final boolean isQueryingCluster;

    public ResolveClusterActionRequest(String[] names) {
        this(names, DEFAULT_INDICES_OPTIONS, false, true);
        assert (names != null && names.length > 0) : "One or more index expressions must be included with this constructor";
    }

    public ResolveClusterActionRequest(String[] names, IndicesOptions indicesOptions, boolean clusterInfoOnly, boolean queryingCluster) {
        this.names = names;
        this.localIndicesRequested = this.localIndicesPresent(names);
        this.indicesOptions = indicesOptions;
        this.clusterInfoOnly = clusterInfoOnly;
        this.isQueryingCluster = queryingCluster;
    }

    public ResolveClusterActionRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            throw new UnsupportedOperationException(ResolveClusterActionRequest.createVersionErrorMessage(in.getTransportVersion()));
        }
        this.names = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.localIndicesRequested = this.localIndicesPresent(this.names);
        if (in.getTransportVersion().onOrAfter(TransportVersions.RESOLVE_CLUSTER_NO_INDEX_EXPRESSION)) {
            this.clusterInfoOnly = in.readBoolean();
            this.isQueryingCluster = in.readBoolean();
        } else {
            this.clusterInfoOnly = false;
            this.isQueryingCluster = false;
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.TIMEOUT_GET_PARAM_FOR_RESOLVE_CLUSTER)) {
            this.timeout = in.readOptionalTimeValue();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            throw new UnsupportedOperationException(ResolveClusterActionRequest.createVersionErrorMessage(out.getTransportVersion()));
        }
        out.writeStringArray(this.names);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.RESOLVE_CLUSTER_NO_INDEX_EXPRESSION)) {
            out.writeBoolean(this.clusterInfoOnly);
            out.writeBoolean(this.isQueryingCluster);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.TIMEOUT_GET_PARAM_FOR_RESOLVE_CLUSTER)) {
            out.writeOptionalTimeValue(this.timeout);
        }
    }

    static String createVersionErrorMessage(TransportVersion versionFound) {
        return Strings.format("%s %s but was %s", TRANSPORT_VERSION_ERROR_MESSAGE_PREFIX, TransportVersions.V_8_13_0.toReleaseVersion(), versionFound.toReleaseVersion());
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveClusterActionRequest request = (ResolveClusterActionRequest)o;
        return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions()) && Objects.equals(this.timeout, request.timeout);
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.timeout);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    @Override
    public String[] indices() {
        return this.names;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public boolean clusterInfoOnly() {
        return this.clusterInfoOnly;
    }

    public boolean queryingCluster() {
        return this.isQueryingCluster;
    }

    public boolean isLocalIndicesRequested() {
        return this.localIndicesRequested;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    protected IndicesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        this.names = indices;
        return this;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                if (ResolveClusterActionRequest.this.indices().length == 0) {
                    return "resolve/cluster";
                }
                return "resolve/cluster for " + Arrays.toString(ResolveClusterActionRequest.this.indices());
            }
        };
    }

    boolean localIndicesPresent(String[] indices) {
        for (String index : indices) {
            if (RemoteClusterAware.isRemoteIndexName(index)) continue;
            return true;
        }
        return false;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public String toString() {
        return "ResolveClusterActionRequest{indices=" + Arrays.toString(this.names) + ", localIndicesRequested=" + this.localIndicesRequested + ", clusterInfoOnly=" + this.clusterInfoOnly + ", queryingCluster=" + this.isQueryingCluster + "}";
    }
}

