/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoScript
implements JsonpSerializable {
    private final String allowedTypes;
    @Nullable
    private final String disableMaxCompilationsRate;
    public static final JsonpDeserializer<NodeInfoScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoScript::setupNodeInfoScriptDeserializer);

    private NodeInfoScript(Builder builder) {
        this.allowedTypes = ApiTypeHelper.requireNonNull(builder.allowedTypes, this, "allowedTypes");
        this.disableMaxCompilationsRate = builder.disableMaxCompilationsRate;
    }

    public static NodeInfoScript of(Function<Builder, ObjectBuilder<NodeInfoScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String allowedTypes() {
        return this.allowedTypes;
    }

    @Nullable
    public final String disableMaxCompilationsRate() {
        return this.disableMaxCompilationsRate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allowed_types");
        generator.write(this.allowedTypes);
        if (this.disableMaxCompilationsRate != null) {
            generator.writeKey("disable_max_compilations_rate");
            generator.write(this.disableMaxCompilationsRate);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoScriptDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowedTypes, JsonpDeserializer.stringDeserializer(), "allowed_types");
        op.add(Builder::disableMaxCompilationsRate, JsonpDeserializer.stringDeserializer(), "disable_max_compilations_rate");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoScript> {
        private String allowedTypes;
        @Nullable
        private String disableMaxCompilationsRate;

        public final Builder allowedTypes(String value) {
            this.allowedTypes = value;
            return this;
        }

        public final Builder disableMaxCompilationsRate(@Nullable String value) {
            this.disableMaxCompilationsRate = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoScript build() {
            this._checkSingleUse();
            return new NodeInfoScript(this);
        }
    }
}

