/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.InferenceContext;

public abstract class BaseInferenceActionRequest
extends LegacyActionRequest {
    private boolean hasBeenRerouted;
    private final InferenceContext context;

    public BaseInferenceActionRequest(InferenceContext context) {
        this.context = context;
    }

    public BaseInferenceActionRequest(StreamInput in) throws IOException {
        super(in);
        this.hasBeenRerouted = in.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING) ? in.readBoolean() : true;
        this.context = in.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_CONTEXT) || in.getTransportVersion().isPatchFrom(TransportVersions.INFERENCE_CONTEXT_8_X) ? new InferenceContext(in) : InferenceContext.EMPTY_INSTANCE;
    }

    public abstract boolean isStreaming();

    public abstract TaskType getTaskType();

    public abstract String getInferenceEntityId();

    public void setHasBeenRerouted(boolean hasBeenRerouted) {
        this.hasBeenRerouted = hasBeenRerouted;
    }

    public boolean hasBeenRerouted() {
        return this.hasBeenRerouted;
    }

    public InferenceContext getContext() {
        return this.context;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING)) {
            out.writeBoolean(this.hasBeenRerouted);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_CONTEXT) || out.getTransportVersion().isPatchFrom(TransportVersions.INFERENCE_CONTEXT_8_X)) {
            this.context.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseInferenceActionRequest that = (BaseInferenceActionRequest)o;
        return this.hasBeenRerouted == that.hasBeenRerouted && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.hasBeenRerouted, this.context);
    }
}

