/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CloseFollowerIndexStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.OpenIndexStep;
import org.elasticsearch.xpack.core.ilm.PauseFollowerIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UnfollowFollowerIndexStep;
import org.elasticsearch.xpack.core.ilm.WaitForFollowShardTasksStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexingCompleteStep;
import org.elasticsearch.xpack.core.ilm.WaitUntilTimeSeriesEndTimePassesStep;

public final class UnfollowAction
implements LifecycleAction {
    public static final String NAME = "unfollow";
    public static final String CCR_METADATA_KEY = "ccr";
    static final String OPEN_FOLLOWER_INDEX_STEP_NAME = "open-follower-index";
    static final String CONDITIONAL_UNFOLLOW_STEP = "branch-check-unfollow-prerequisites";
    public static final UnfollowAction INSTANCE = new UnfollowAction();
    private static final ObjectParser<UnfollowAction, Void> PARSER = new ObjectParser("unfollow", () -> INSTANCE);

    private UnfollowAction() {
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey preUnfollowKey = new Step.StepKey(phase, NAME, CONDITIONAL_UNFOLLOW_STEP);
        Step.StepKey indexingComplete = new Step.StepKey(phase, NAME, "wait-for-indexing-complete");
        Step.StepKey waitUntilTimeSeriesEndTimePassesStep = new Step.StepKey(phase, NAME, "check-ts-end-time-passed");
        Step.StepKey waitForFollowShardTasks = new Step.StepKey(phase, NAME, "wait-for-follow-shard-tasks");
        Step.StepKey pauseFollowerIndex = new Step.StepKey(phase, NAME, "pause-follower-index");
        Step.StepKey closeFollowerIndex = new Step.StepKey(phase, NAME, "close-follower-index");
        Step.StepKey unfollowFollowerIndex = new Step.StepKey(phase, NAME, "unfollow-follower-index");
        Step.StepKey openFollowerIndex = new Step.StepKey(phase, NAME, OPEN_FOLLOWER_INDEX_STEP_NAME);
        Step.StepKey waitForYellowStep = new Step.StepKey(phase, NAME, "wait-for-index-color");
        BranchingStep conditionalSkipUnfollowStep = new BranchingStep(preUnfollowKey, indexingComplete, nextStepKey, (index, project) -> {
            IndexMetadata followerIndex = project.index((Index)index);
            Map<String, String> customIndexMetadata = followerIndex.getCustomData(CCR_METADATA_KEY);
            return customIndexMetadata == null;
        });
        WaitForIndexingCompleteStep step1 = new WaitForIndexingCompleteStep(indexingComplete, waitUntilTimeSeriesEndTimePassesStep);
        WaitUntilTimeSeriesEndTimePassesStep step2 = new WaitUntilTimeSeriesEndTimePassesStep(waitUntilTimeSeriesEndTimePassesStep, waitForFollowShardTasks, Instant::now);
        WaitForFollowShardTasksStep step3 = new WaitForFollowShardTasksStep(waitForFollowShardTasks, pauseFollowerIndex, client);
        PauseFollowerIndexStep step4 = new PauseFollowerIndexStep(pauseFollowerIndex, closeFollowerIndex, client);
        CloseFollowerIndexStep step5 = new CloseFollowerIndexStep(closeFollowerIndex, unfollowFollowerIndex, client);
        UnfollowFollowerIndexStep step6 = new UnfollowFollowerIndexStep(unfollowFollowerIndex, openFollowerIndex, client);
        OpenIndexStep step7 = new OpenIndexStep(openFollowerIndex, waitForYellowStep, client);
        WaitForIndexColorStep step8 = new WaitForIndexColorStep(waitForYellowStep, nextStepKey, ClusterHealthStatus.YELLOW);
        return List.of(conditionalSkipUnfollowStep, step1, step2, step3, step4, step5, step6, step7, step8);
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    public static UnfollowAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return 36970;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return Strings.toString(this);
    }
}

