/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.ReservedStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ProjectClusterStateHandlerAdapter;
import org.elasticsearch.reservedstate.service.ReservedClusterStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedProjectStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTask;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class ReservedClusterStateService {
    private static final Logger logger = LogManager.getLogger(ReservedClusterStateService.class);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    private final Map<String, ReservedStateHandler<?>> allHandlers;
    private final Map<String, ReservedClusterStateHandler<?>> clusterHandlers;
    private final Map<String, ReservedProjectStateHandler<?>> projectHandlers;
    private final ClusterService clusterService;
    private final ReservedStateUpdateTaskExecutor updateTaskExecutor;
    private final ReservedStateErrorTaskExecutor errorTaskExecutor;
    private final ConstructingObjectParser<ReservedStateChunk, Void> stateChunkParser = new ConstructingObjectParser("reserved_state_chunk", a -> {
        List tuples = (List)a[0];
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        for (Tuple tuple : tuples) {
            stateMap.put((String)tuple.v1(), tuple.v2());
        }
        return new ReservedStateChunk(stateMap, (ReservedStateVersion)a[1]);
    });

    private static <T> ReservedClusterStateHandler<T> adaptForDefaultProject(ReservedProjectStateHandler<T> handler) {
        return new ProjectClusterStateHandlerAdapter<T>(Metadata.DEFAULT_PROJECT_ID, handler);
    }

    static ProjectMetadata getPotentiallyNewProject(ClusterState state, ProjectId projectId) {
        return state.metadata().hasProject(projectId) ? state.metadata().getProject(projectId) : ProjectMetadata.builder(projectId).build();
    }

    public ReservedClusterStateService(ClusterService clusterService, RerouteService rerouteService, List<ReservedClusterStateHandler<?>> clusterHandlerList, List<ReservedProjectStateHandler<?>> projectHandlerList) {
        this.clusterService = clusterService;
        this.updateTaskExecutor = new ReservedStateUpdateTaskExecutor(rerouteService);
        this.errorTaskExecutor = new ReservedStateErrorTaskExecutor();
        this.allHandlers = Stream.concat(clusterHandlerList.stream(), projectHandlerList.stream()).collect(Collectors.toMap(ReservedStateHandler::name, Function.identity(), (v1, v2) -> {
            throw new IllegalArgumentException("Duplicate handler name: [" + v1.name() + "]");
        }));
        this.clusterHandlers = Stream.concat(clusterHandlerList.stream(), projectHandlerList.stream().map(ReservedClusterStateService::adaptForDefaultProject)).collect(Collectors.toMap(ReservedStateHandler::name, Function.identity()));
        this.projectHandlers = projectHandlerList.stream().collect(Collectors.toMap(ReservedStateHandler::name, Function.identity()));
        this.stateChunkParser.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> {
            ReservedStateHandler<?> handler = this.allHandlers.get(name);
            if (handler == null) {
                throw new IllegalStateException("Missing handler definition for content key [" + name + "]");
            }
            p.nextToken();
            return new Tuple(name, handler.fromXContent(p));
        }, STATE_FIELD);
        this.stateChunkParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ReservedStateVersion.parse(p), METADATA_FIELD);
    }

    ReservedStateChunk parse(String namespace, XContentParser parser) {
        try {
            return this.stateChunkParser.apply(parser, null);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, ReservedStateMetadata.EMPTY_VERSION, ReservedStateVersionCheck.HIGHER_VERSION_ONLY, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            throw new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e);
        }
    }

    public void process(String namespace, XContentParser parser, ReservedStateVersionCheck versionCheck, Consumer<Exception> errorListener) {
        ReservedStateChunk stateChunk;
        try {
            stateChunk = this.parse(namespace, parser);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, ReservedStateMetadata.EMPTY_VERSION, versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        this.process(namespace, stateChunk, versionCheck, errorListener);
    }

    public ReservedStateChunk parse(ProjectId projectId, String namespace, XContentParser parser) {
        try {
            return this.stateChunkParser.apply(parser, null);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(projectId, namespace, ReservedStateMetadata.EMPTY_VERSION, ReservedStateVersionCheck.HIGHER_VERSION_ONLY, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing project [{}] change request for [{}] with the following errors [{}]", (Object)projectId, (Object)namespace, (Object)errorState);
            throw new IllegalStateException("Error processing project " + String.valueOf(projectId) + " change request for " + namespace + ", errors: " + String.valueOf(errorState), e);
        }
    }

    public void process(ProjectId projectId, String namespace, XContentParser parser, ReservedStateVersionCheck versionCheck, Consumer<Exception> errorListener) {
        ReservedStateChunk stateChunk;
        try {
            stateChunk = this.parse(projectId, namespace, parser);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(projectId, namespace, ReservedStateMetadata.EMPTY_VERSION, versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing project [{}] change request for [{}] with the following errors [{}]", (Object)projectId, (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing project " + String.valueOf(projectId) + " change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        this.process(projectId, namespace, stateChunk, versionCheck, errorListener);
    }

    public void initEmpty(String namespace, ActionListener<ActionResponse.Empty> listener) {
        ReservedStateVersion missingVersion = new ReservedStateVersion(ReservedStateMetadata.EMPTY_VERSION, BuildVersion.current());
        ReservedStateChunk emptyState = new ReservedStateChunk(Map.of(), missingVersion);
        this.submitUpdateTask("empty initial cluster state [" + namespace + "]", new ReservedClusterStateUpdateTask(namespace, emptyState, ReservedStateVersionCheck.HIGHER_VERSION_ONLY, Map.of(), (Collection<String>)List.of(), errorState -> {
            throw new AssertionError();
        }, listener));
    }

    public void process(final String namespace, ReservedStateChunk reservedStateChunk, final ReservedStateVersionCheck versionCheck, final Consumer<Exception> errorListener) {
        SequencedSet<String> orderedHandlers;
        Map<String, Object> reservedState = reservedStateChunk.state();
        final ReservedStateVersion reservedStateVersion = reservedStateChunk.metadata();
        try {
            orderedHandlers = this.orderedClusterStateHandlers(reservedState.keySet());
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, reservedStateVersion.version(), versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        ClusterState state = this.clusterService.state();
        final ReservedStateMetadata existingMetadata = state.metadata().reservedStateMetadata().get(namespace);
        if (!ReservedStateUpdateTask.checkMetadataVersion(Optional.empty(), namespace, existingMetadata, reservedStateVersion, versionCheck)) {
            errorListener.accept(null);
            return;
        }
        List<String> trialRunErrors = this.trialRun(namespace, state, reservedStateChunk, orderedHandlers);
        Exception error = this.checkAndReportError(Optional.empty(), namespace, trialRunErrors, reservedStateVersion, versionCheck);
        if (error != null) {
            errorListener.accept(error);
            return;
        }
        this.submitUpdateTask("reserved cluster state [" + namespace + "]", new ReservedClusterStateUpdateTask(namespace, reservedStateChunk, versionCheck, this.clusterHandlers, (Collection<String>)orderedHandlers, this::updateErrorState, new ActionListener<ActionResponse.Empty>(this){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved cluster state for namespace [{}]", (Object)namespace);
                errorListener.accept(null);
            }

            @Override
            public void onFailure(Exception e) {
                if (ReservedStateErrorTask.isNewError(existingMetadata, reservedStateVersion.version(), versionCheck)) {
                    logger.debug("Failed to apply reserved cluster state", (Throwable)e);
                    errorListener.accept(e);
                } else {
                    errorListener.accept(null);
                }
            }
        }));
    }

    public void process(ProjectId projectId, String namespace, ReservedStateChunk reservedStateChunk, ReservedStateVersionCheck versionCheck, Consumer<Exception> errorListener) {
        this.process(projectId, namespace, List.of(reservedStateChunk), versionCheck, errorListener);
    }

    public void process(final ProjectId projectId, final String namespace, List<ReservedStateChunk> reservedStateChunks, final ReservedStateVersionCheck versionCheck, final Consumer<Exception> errorListener) {
        LinkedHashSet<String> orderedHandlers;
        ReservedStateVersion reservedStateVersion;
        ReservedStateChunk reservedStateChunk;
        try {
            reservedStateChunk = ReservedClusterStateService.mergeReservedStateChunks(reservedStateChunks);
            Map<String, Object> reservedState = reservedStateChunk.state();
            reservedStateVersion = reservedStateChunk.metadata();
            orderedHandlers = this.orderedProjectStateHandlers(reservedState.keySet());
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(projectId, namespace, reservedStateChunks.isEmpty() ? ReservedStateMetadata.EMPTY_VERSION : reservedStateChunks.getFirst().metadata().version(), versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing project [{}] change request for [{}] with the following errors [{}]", (Object)projectId, (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing project " + String.valueOf(projectId) + " change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        ClusterState state = this.clusterService.state();
        ProjectMetadata projectMetadata = ReservedClusterStateService.getPotentiallyNewProject(state, projectId);
        state = ClusterState.builder(state).putProjectMetadata(projectMetadata).build();
        final ReservedStateMetadata existingMetadata = projectMetadata.reservedStateMetadata().get(namespace);
        if (!ReservedStateUpdateTask.checkMetadataVersion(Optional.of(projectId), namespace, existingMetadata, reservedStateVersion, versionCheck)) {
            errorListener.accept(null);
            return;
        }
        List<String> trialRunErrors = this.trialRun(namespace, state, reservedStateChunk, orderedHandlers);
        Exception error = this.checkAndReportError(Optional.of(projectId), namespace, trialRunErrors, reservedStateVersion, versionCheck);
        if (error != null) {
            errorListener.accept(error);
            return;
        }
        this.submitUpdateTask("reserved cluster state [" + namespace + "]", new ReservedProjectStateUpdateTask(projectId, namespace, reservedStateChunk, versionCheck, this.projectHandlers, orderedHandlers, this::updateErrorState, new ActionListener<ActionResponse.Empty>(this){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved cluster state for project [{}] namespace [{}]", (Object)projectId, (Object)namespace);
                errorListener.accept(null);
            }

            @Override
            public void onFailure(Exception e) {
                if (ReservedStateErrorTask.isNewError(existingMetadata, reservedStateVersion.version(), versionCheck)) {
                    logger.debug("Failed to apply reserved cluster state", (Throwable)e);
                    errorListener.accept(e);
                } else {
                    errorListener.accept(null);
                }
            }
        }));
    }

    private static ReservedStateChunk mergeReservedStateChunks(List<ReservedStateChunk> chunks) {
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("No chunks provided");
        }
        if (chunks.size() == 1) {
            return chunks.getFirst();
        }
        ReservedStateVersion reservedStateVersion = chunks.getFirst().metadata();
        HashMap<String, Object> mergedChunks = new HashMap<String, Object>(chunks.size());
        for (ReservedStateChunk chunk : chunks) {
            Set<String> duplicateKeys = Sets.intersection(chunk.state().keySet(), mergedChunks.keySet());
            if (!chunk.metadata().equals(reservedStateVersion)) {
                throw new IllegalStateException("Failed to merge reserved state chunks because of version mismatch: [" + String.valueOf(reservedStateVersion) + "] != [" + String.valueOf(chunk.metadata()) + "]");
            }
            if (!duplicateKeys.isEmpty()) {
                throw new IllegalStateException("Failed to merge reserved state chunks because of duplicate keys: " + String.valueOf(duplicateKeys));
            }
            mergedChunks.putAll(chunk.state());
        }
        return new ReservedStateChunk(mergedChunks, reservedStateVersion);
    }

    Exception checkAndReportError(Optional<ProjectId> projectId, String namespace, List<String> errors, ReservedStateVersion reservedStateVersion, ReservedStateVersionCheck versionCheck) {
        if (!errors.isEmpty()) {
            logger.debug("Error processing state change request for [{}] with the following errors [{}]", (Object)namespace, errors);
            ErrorState errorState = new ErrorState(projectId, namespace, reservedStateVersion.version(), versionCheck, errors, ReservedStateErrorMetadata.ErrorKind.VALIDATION);
            this.updateErrorState(errorState);
            return new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState));
        }
        return null;
    }

    void submitUpdateTask(String source, ReservedStateUpdateTask<?> task) {
        MasterServiceTaskQueue<ReservedStateUpdateTask<?>> updateTaskQueue = this.clusterService.createTaskQueue("reserved state update", Priority.URGENT, this.updateTaskExecutor);
        updateTaskQueue.submitTask(source, task, null);
    }

    void updateErrorState(ErrorState errorState) {
        if (!ReservedStateErrorTask.checkErrorVersion(this.clusterService.state(), errorState)) {
            return;
        }
        if (errorState.projectId().isPresent() && !this.clusterService.state().metadata().hasProject(errorState.projectId().get())) {
            return;
        }
        this.submitErrorUpdateTask(errorState);
    }

    private void submitErrorUpdateTask(final ErrorState errorState) {
        MasterServiceTaskQueue<ReservedStateErrorTask> errorTaskQueue = this.clusterService.createTaskQueue("reserved state error", Priority.URGENT, this.errorTaskExecutor);
        errorTaskQueue.submitTask("reserved cluster state update error for [ " + errorState.namespace() + "]", new ReservedStateErrorTask(errorState, new ActionListener<ActionResponse.Empty>(this){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved error state for namespace [{}]", (Object)errorState.namespace());
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("Failed to apply reserved error cluster state", (Throwable)e);
            }
        }), null);
    }

    List<String> trialRun(String namespace, ClusterState currentState, ReservedStateChunk stateChunk, SequencedSet<String> orderedHandlers) {
        return ReservedClusterStateService.trialRun(currentState.metadata().reservedStateMetadata().get(namespace), currentState, stateChunk, this.clusterHandlers, orderedHandlers);
    }

    List<String> trialRun(ProjectId projectId, String namespace, ClusterState currentState, ReservedStateChunk stateChunk, SequencedSet<String> orderedHandlers) {
        return ReservedClusterStateService.trialRun(projectId, currentState.metadata().reservedStateMetadata().get(namespace), currentState, stateChunk, this.projectHandlers, orderedHandlers);
    }

    private static List<String> trialRun(ProjectId projectId, ReservedStateMetadata existingMetadata, ClusterState currentState, ReservedStateChunk stateChunk, Map<String, ReservedProjectStateHandler<?>> handlers, SequencedSet<String> orderedHandlers) {
        Map<String, Object> reservedState = stateChunk.state();
        ArrayList<String> errors = new ArrayList<String>();
        for (String handlerName : orderedHandlers) {
            ReservedProjectStateHandler<?> handler = handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(existingMetadata, handlerName);
                TransformState transformState = ReservedClusterStateService.transform(handler, projectId, reservedState.get(handlerName), new TransformState(currentState, existingKeys));
                currentState = transformState.state();
            }
            catch (Exception e) {
                errors.add(Strings.format("Error processing %s state change: %s", handler.name(), ExceptionsHelper.stackTrace(e)));
            }
        }
        return errors;
    }

    private static List<String> trialRun(ReservedStateMetadata existingMetadata, ClusterState currentState, ReservedStateChunk stateChunk, Map<String, ReservedClusterStateHandler<?>> handlers, SequencedSet<String> orderedHandlers) {
        Map<String, Object> reservedState = stateChunk.state();
        ArrayList<String> errors = new ArrayList<String>();
        for (String handlerName : orderedHandlers) {
            ReservedClusterStateHandler<?> handler = handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(existingMetadata, handlerName);
                TransformState transformState = ReservedClusterStateService.transform(handler, reservedState.get(handlerName), new TransformState(currentState, existingKeys));
                currentState = transformState.state();
            }
            catch (Exception e) {
                errors.add(Strings.format("Error processing %s state change: %s", handler.name(), ExceptionsHelper.stackTrace(e)));
            }
        }
        return errors;
    }

    static <S, T> TransformState transform(ReservedClusterStateHandler<T> handler, Object state, TransformState transform) throws Exception {
        return handler.transform(state, transform);
    }

    static <S, T> TransformState transform(ReservedProjectStateHandler<T> handler, ProjectId projectId, Object state, TransformState transformState) throws Exception {
        return handler.transform(projectId, state, transformState);
    }

    SequencedSet<String> orderedClusterStateHandlers(Set<String> handlerNames) {
        LinkedHashSet<String> orderedHandlers = new LinkedHashSet<String>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (String key : handlerNames) {
            this.addStateHandler(this.clusterHandlers, key, handlerNames, orderedHandlers, dependencyStack);
        }
        return orderedHandlers;
    }

    LinkedHashSet<String> orderedProjectStateHandlers(Set<String> handlerNames) {
        LinkedHashSet<String> orderedHandlers = new LinkedHashSet<String>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (String key : handlerNames) {
            this.addStateHandler(this.projectHandlers, key, handlerNames, orderedHandlers, dependencyStack);
        }
        return orderedHandlers;
    }

    private void addStateHandler(Map<String, ? extends ReservedStateHandler<?>> handlers, String key, Set<String> keys, SequencedSet<String> ordered, SequencedSet<String> visited) {
        if (visited.contains(key)) {
            StringBuilder msg = new StringBuilder("Cycle found in settings dependencies: ");
            visited.forEach(s -> {
                msg.append((String)s);
                msg.append(" -> ");
            });
            msg.append(key);
            throw new IllegalStateException(msg.toString());
        }
        if (ordered.contains(key)) {
            return;
        }
        visited.add(key);
        ReservedStateHandler<?> handler = handlers.get(key);
        if (handler == null) {
            throw new IllegalStateException("Unknown handler type: " + key);
        }
        for (String dependency : handler.dependencies()) {
            if (!keys.contains(dependency)) {
                throw new IllegalStateException("Missing handler dependency definition: " + key + " -> " + dependency);
            }
            this.addStateHandler(handlers, dependency, keys, ordered, visited);
        }
        for (String dependency : handler.optionalDependencies()) {
            if (!keys.contains(dependency)) continue;
            this.addStateHandler(handlers, dependency, keys, ordered, visited);
        }
        visited.remove(key);
        ordered.add(key);
    }

    public void installClusterStateHandler(ReservedClusterStateHandler<?> handler) {
        this.allHandlers.put(handler.name(), handler);
        this.clusterHandlers.put(handler.name(), handler);
    }

    public void installProjectStateHandler(ReservedProjectStateHandler<?> handler) {
        this.allHandlers.put(handler.name(), handler);
        this.projectHandlers.put(handler.name(), handler);
        this.clusterHandlers.put(handler.name(), ReservedClusterStateService.adaptForDefaultProject(handler));
    }
}

