/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.IOUtils;

public class ES85BloomFilterPostingsFormat
extends PostingsFormat {
    static final String BLOOM_CODEC_NAME = "ES85BloomFilter";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String BLOOM_FILTER_META_FILE = "bfm";
    static final String BLOOM_FILTER_INDEX_FILE = "bfi";

    public ES85BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    @Override
    public String toString() {
        return BLOOM_CODEC_NAME;
    }

    static String metaFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName(si.name, segmentSuffix, BLOOM_FILTER_META_FILE);
    }

    static String indexFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName(si.name, segmentSuffix, BLOOM_FILTER_INDEX_FILE);
    }

    static int bloomFilterSize(int maxDocs) {
        long numBits = (long)maxDocs * 10L;
        if (numBits > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)numBits;
    }

    static int numBytesForBloomFilter(int bloomFilterSize) {
        return Math.toIntExact(((long)bloomFilterSize + 7L) / 8L);
    }

    static int hashTerm(BytesRef br) {
        int hash = ES85BloomFilterPostingsFormat.murmurhash3_x86_32(br.bytes, br.offset, br.length, -1756908916);
        return hash & Integer.MAX_VALUE;
    }

    private static int murmurhash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = BitUtil.VH_LE_INT.get(data, i);
            k1 *= -862048943;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= 461845907);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    static final class FieldsReader
    extends FieldsProducer {
        private final Map<String, BloomFilter> bloomFilters;
        private final List<Closeable> toCloses = new ArrayList<Closeable>();
        private final Map<String, FieldsProducer> readerMap = new HashMap<String, FieldsProducer>();
        private final IndexInput indexIn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsReader(SegmentReadState state) throws IOException {
            boolean success = false;
            try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(ES85BloomFilterPostingsFormat.metaFile(state.segmentInfo, state.segmentSuffix));){
                CodecUtil.checkIndexHeader(metaIn, ES85BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                int numFieldsGroups = metaIn.readVInt();
                for (int i = 0; i < numFieldsGroups; ++i) {
                    FieldsGroup group = FieldsGroup.readFrom(metaIn, state.fieldInfos);
                    FieldsProducer reader = group.postingsFormat.fieldsProducer(new SegmentReadState(state, group.suffix));
                    this.toCloses.add(reader);
                    for (String field : group.fields) {
                        this.readerMap.put(field, reader);
                    }
                }
                int numBloomFilters = metaIn.readVInt();
                this.bloomFilters = new HashMap<String, BloomFilter>(numBloomFilters);
                for (int i = 0; i < numBloomFilters; ++i) {
                    BloomFilter bloomFilter = BloomFilter.readFrom(metaIn, state.fieldInfos);
                    this.bloomFilters.put(bloomFilter.field, bloomFilter);
                }
                CodecUtil.checkFooter(metaIn);
                this.indexIn = state.directory.openInput(ES85BloomFilterPostingsFormat.indexFile(state.segmentInfo, state.segmentSuffix), state.context);
                this.toCloses.add(this.indexIn);
                CodecUtil.checkIndexHeader(this.indexIn, ES85BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(this.indexIn);
                assert (this.assertBloomFilterSizes(state.segmentInfo));
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toCloses);
                }
            }
        }

        private boolean assertBloomFilterSizes(SegmentInfo segmentInfo) {
            for (BloomFilter bloomFilter : this.bloomFilters.values()) {
                assert (bloomFilter.bloomFilterSize == ES85BloomFilterPostingsFormat.bloomFilterSize(segmentInfo.maxDoc())) : "bloom_filter=" + String.valueOf(bloomFilter) + ", max_docs=" + segmentInfo.maxDoc();
            }
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return this.readerMap.keySet().iterator();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.toCloses);
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldsProducer reader = this.readerMap.get(field);
            if (reader == null) {
                return null;
            }
            Terms terms = reader.terms(field);
            if (terms == null) {
                return null;
            }
            BloomFilter bloomFilter = this.bloomFilters.get(field);
            if (bloomFilter != null) {
                RandomAccessInput data = this.indexIn.randomAccessSlice(bloomFilter.startFilePointer(), ES85BloomFilterPostingsFormat.numBytesForBloomFilter(bloomFilter.bloomFilterSize));
                return new BloomFilterTerms(terms, data, bloomFilter.bloomFilterSize);
            }
            return terms;
        }

        @Override
        public int size() {
            return this.readerMap.size();
        }

        @Override
        public void checkIntegrity() throws IOException {
            CodecUtil.checksumEntireFile(this.indexIn);
            HashSet<FieldsProducer> seenReaders = new HashSet<FieldsProducer>();
            for (FieldsProducer reader : this.readerMap.values()) {
                if (!seenReaders.add(reader)) continue;
                reader.checkIntegrity();
            }
        }
    }

    private static abstract class LazyFilterTermsEnum
    extends BaseTermsEnum {
        private LazyFilterTermsEnum() {
        }

        abstract TermsEnum getDelegate() throws IOException;

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        @Override
        public BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        @Override
        public long ord() throws IOException {
            return this.getDelegate().ord();
        }

        @Override
        public int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.getDelegate().postings(reuse, flags);
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            return this.getDelegate().impacts(flags);
        }

        @Override
        public BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        @Override
        public AttributeSource attributes() {
            try {
                return this.getDelegate().attributes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class BloomFilterTerms
    extends FilterLeafReader.FilterTerms {
        private final RandomAccessInput data;
        private final int bloomFilterSize;

        BloomFilterTerms(Terms in, RandomAccessInput data, int bloomFilterSize) {
            super(in);
            this.data = data;
            this.bloomFilterSize = bloomFilterSize;
        }

        private boolean mayContainTerm(BytesRef term) throws IOException {
            int hash = ES85BloomFilterPostingsFormat.hashTerm(term) % this.bloomFilterSize;
            int pos = hash >> 3;
            int mask = 1 << (hash & 7);
            byte bits = this.data.readByte(pos);
            return (bits & mask) != 0;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new LazyFilterTermsEnum(){
                private TermsEnum delegate;

                @Override
                TermsEnum getDelegate() throws IOException {
                    if (this.delegate == null) {
                        this.delegate = in.iterator();
                    }
                    return this.delegate;
                }

                @Override
                public boolean seekExact(BytesRef term) throws IOException {
                    if (this.mayContainTerm(term)) {
                        return this.getDelegate().seekExact(term);
                    }
                    return false;
                }

                @Override
                public void seekExact(BytesRef term, TermState state) throws IOException {
                    this.getDelegate().seekExact(term, state);
                }

                @Override
                public TermState termState() throws IOException {
                    return this.getDelegate().termState();
                }
            };
        }
    }

    record FieldsGroup(PostingsFormat postingsFormat, String suffix, List<String> fields) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeString(this.postingsFormat.getName());
            out.writeString(this.suffix);
            out.writeVInt(this.fields.size());
            for (String field : this.fields) {
                out.writeVInt(fieldInfos.fieldInfo((String)field).number);
            }
        }

        static FieldsGroup readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            PostingsFormat postingsFormat = PostingsFormat.forName(in.readString());
            String suffix = in.readString();
            int numFields = in.readVInt();
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < numFields; ++i) {
                fields.add(fieldInfos.fieldInfo((int)in.readVInt()).name);
            }
            return new FieldsGroup(postingsFormat, suffix, fields);
        }
    }

    record BloomFilter(String field, long startFilePointer, int bloomFilterSize) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeVInt(fieldInfos.fieldInfo((String)this.field).number);
            out.writeVLong(this.startFilePointer);
            out.writeVInt(this.bloomFilterSize);
        }

        static BloomFilter readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            String fieldName = fieldInfos.fieldInfo((int)in.readVInt()).name;
            long startFilePointer = in.readVLong();
            int bloomFilterSize = in.readVInt();
            return new BloomFilter(fieldName, startFilePointer, bloomFilterSize);
        }
    }
}

