/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterStateAction.class);
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportClusterStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver) {
        super("cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, ClusterStateRequest::new, ClusterStateResponse::new, threadPool.executor("management"));
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(Task task, final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<Object> acceptableClusterStateOrFailedPredicate;
        assert (task instanceof CancellableTask) : String.valueOf(task) + " not cancellable";
        final CancellableTask cancellableTask = (CancellableTask)task;
        final Predicate<Object> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? Predicates.always() : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<Object> predicate = acceptableClusterStateOrFailedPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedMaster());
        if (cancellableTask.notifyIfCancelled(listener)) {
            return;
        }
        if (acceptableClusterStatePredicate.test(state)) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        } else {
            assert (!acceptableClusterStateOrFailedPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService, request.waitForTimeout(), logger, this.threadPool.getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (cancellableTask.notifyIfCancelled(listener)) {
                        return;
                    }
                    if (acceptableClusterStatePredicate.test(newState)) {
                        TransportClusterStateAction.this.executor.execute(ActionRunnable.supply(listener, () -> TransportClusterStateAction.this.buildResponse(request, newState)));
                    } else {
                        listener.onFailure(new NotMasterException("master stepped down waiting for metadata version " + request.waitForMetadataVersion()));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    ActionListener.run(listener, l -> {
                        if (!cancellableTask.notifyIfCancelled(l)) {
                            l.onResponse(new ClusterStateResponse(state.getClusterName(), null, true));
                        }
                    });
                }
            }, clusterState -> cancellableTask.isCancelled() || acceptableClusterStateOrFailedPredicate.test(clusterState));
        }
    }

    private ClusterState filterClusterState(ClusterState inputState) {
        Metadata metadata;
        Collection<ProjectId> projectIds = this.projectResolver.getProjectIds(inputState);
        if (projectIds.containsAll((metadata = inputState.metadata()).projects().keySet()) && projectIds.containsAll(inputState.globalRoutingTable().routingTables().keySet())) {
            return inputState;
        }
        Metadata.Builder mdBuilder = Metadata.builder(inputState.metadata());
        GlobalRoutingTable.Builder rtBuilder = GlobalRoutingTable.builder(inputState.globalRoutingTable());
        for (ProjectId projectId : metadata.projects().keySet()) {
            if (projectIds.contains(projectId)) continue;
            mdBuilder.removeProject(projectId);
            rtBuilder.removeProject(projectId);
        }
        return ClusterState.builder(inputState).metadata(mdBuilder.build()).routingTable(rtBuilder.build()).build();
    }

    @SuppressForbidden(reason="exposing ClusterState#compatibilityVersions requires reading them")
    private static Map<String, CompatibilityVersions> getCompatibilityVersions(ClusterState clusterState) {
        return clusterState.compatibilityVersions();
    }

    @SuppressForbidden(reason="exposing ClusterState#clusterFeatures requires reading them")
    private static Map<String, Set<String>> getClusterFeatures(ClusterState clusterState) {
        return clusterState.clusterFeatures().nodeFeatures();
    }

    private ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState rawState) {
        String[] indices;
        ClusterBlockException blockException;
        ClusterState currentState = this.filterClusterState(rawState);
        ThreadPool.assertCurrentThreadPool("management");
        if (!request.blocks() && (blockException = currentState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ)) != null) {
            throw blockException;
        }
        logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
            builder.nodeIdsToCompatibilityVersions(TransportClusterStateAction.getCompatibilityVersions(currentState));
            builder.nodeFeatures(TransportClusterStateAction.getClusterFeatures(currentState));
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                GlobalRoutingTable.Builder globalRoutingTableBuilder = GlobalRoutingTable.builder(currentState.globalRoutingTable()).clear();
                for (ProjectMetadata projectMetadata : currentState.metadata().projects().values()) {
                    RoutingTable projectRouting = currentState.routingTable(projectMetadata.id());
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                    for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, (IndicesRequest)request)) {
                        if (!projectRouting.hasIndex(filteredIndex)) continue;
                        routingTableBuilder.add(projectRouting.getIndicesRouting().get(filteredIndex));
                    }
                    globalRoutingTableBuilder.put(projectMetadata.id(), routingTableBuilder);
                }
                builder.routingTable(globalRoutingTableBuilder.build());
            } else {
                builder.routingTable(currentState.globalRoutingTable());
            }
        } else {
            builder.routingTable(GlobalRoutingTable.builder().build());
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        mdBuilder.coordinationMetadata(currentState.coordinationMetadata());
        if (request.metadata()) {
            BiPredicate<String, Metadata.MetadataCustom> notApi = (ignore, custom) -> !custom.context().contains((Object)Metadata.XContentContext.API);
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metadata().version());
            } else {
                mdBuilder = Metadata.builder(currentState.metadata());
                mdBuilder.removeCustomIf(notApi);
            }
            for (ProjectMetadata project : currentState.metadata().projects().values()) {
                ProjectMetadata.Builder pBuilder;
                if (request.indices().length > 0) {
                    pBuilder = ProjectMetadata.builder(project.id());
                    for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(project, (IndicesRequest)request)) {
                        IndexAbstraction indexAbstraction = (IndexAbstraction)project.getIndicesLookup().get(filteredIndex);
                        if (indexAbstraction.getParentDataStream() != null) {
                            DataStream dataStream = indexAbstraction.getParentDataStream();
                            for (Index backingIndex : dataStream.getIndices()) {
                                pBuilder.put(project.index(backingIndex), false);
                            }
                            pBuilder.put(dataStream);
                            continue;
                        }
                        IndexMetadata indexMetadata = project.index(filteredIndex);
                        if (indexMetadata == null) continue;
                        pBuilder.put(indexMetadata, false);
                    }
                } else {
                    pBuilder = ProjectMetadata.builder(project);
                    pBuilder.removeCustomIf(notApi);
                }
                mdBuilder.put(pBuilder);
            }
        } else {
            for (ProjectId projectId : currentState.metadata().projects().keySet()) {
                mdBuilder.put(ProjectMetadata.builder(projectId));
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (Map.Entry entry : currentState.customs().entrySet()) {
                if (((ClusterState.Custom)entry.getValue()).isPrivate()) continue;
                builder.putCustom((String)entry.getKey(), (ClusterState.Custom)entry.getValue());
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }
}

