/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TokenizationTruncate;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class CommonTokenizationConfig
implements JsonpSerializable {
    @Nullable
    private final Boolean doLowerCase;
    @Nullable
    private final Integer maxSequenceLength;
    @Nullable
    private final Integer span;
    @Nullable
    private final TokenizationTruncate truncate;
    @Nullable
    private final Boolean withSpecialTokens;

    protected CommonTokenizationConfig(AbstractBuilder<?> builder) {
        this.doLowerCase = ((AbstractBuilder)builder).doLowerCase;
        this.maxSequenceLength = ((AbstractBuilder)builder).maxSequenceLength;
        this.span = ((AbstractBuilder)builder).span;
        this.truncate = ((AbstractBuilder)builder).truncate;
        this.withSpecialTokens = ((AbstractBuilder)builder).withSpecialTokens;
    }

    @Nullable
    public final Boolean doLowerCase() {
        return this.doLowerCase;
    }

    @Nullable
    public final Integer maxSequenceLength() {
        return this.maxSequenceLength;
    }

    @Nullable
    public final Integer span() {
        return this.span;
    }

    @Nullable
    public final TokenizationTruncate truncate() {
        return this.truncate;
    }

    @Nullable
    public final Boolean withSpecialTokens() {
        return this.withSpecialTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doLowerCase != null) {
            generator.writeKey("do_lower_case");
            generator.write(this.doLowerCase);
        }
        if (this.maxSequenceLength != null) {
            generator.writeKey("max_sequence_length");
            generator.write(this.maxSequenceLength);
        }
        if (this.span != null) {
            generator.writeKey("span");
            generator.write(this.span);
        }
        if (this.truncate != null) {
            generator.writeKey("truncate");
            this.truncate.serialize(generator, mapper);
        }
        if (this.withSpecialTokens != null) {
            generator.writeKey("with_special_tokens");
            generator.write(this.withSpecialTokens);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCommonTokenizationConfigDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::doLowerCase, JsonpDeserializer.booleanDeserializer(), "do_lower_case");
        op.add(AbstractBuilder::maxSequenceLength, JsonpDeserializer.integerDeserializer(), "max_sequence_length");
        op.add(AbstractBuilder::span, JsonpDeserializer.integerDeserializer(), "span");
        op.add(AbstractBuilder::truncate, TokenizationTruncate._DESERIALIZER, "truncate");
        op.add(AbstractBuilder::withSpecialTokens, JsonpDeserializer.booleanDeserializer(), "with_special_tokens");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Boolean doLowerCase;
        @Nullable
        private Integer maxSequenceLength;
        @Nullable
        private Integer span;
        @Nullable
        private TokenizationTruncate truncate;
        @Nullable
        private Boolean withSpecialTokens;

        public final BuilderT doLowerCase(@Nullable Boolean value) {
            this.doLowerCase = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxSequenceLength(@Nullable Integer value) {
            this.maxSequenceLength = value;
            return (BuilderT)this.self();
        }

        public final BuilderT span(@Nullable Integer value) {
            this.span = value;
            return (BuilderT)this.self();
        }

        public final BuilderT truncate(@Nullable TokenizationTruncate value) {
            this.truncate = value;
            return (BuilderT)this.self();
        }

        public final BuilderT withSpecialTokens(@Nullable Boolean value) {
            this.withSpecialTokens = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

