"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expectDuration = expectDuration;
exports.expectSuppressionFields = expectSuppressionFields;
exports.setDuration = setDuration;
exports.setDurationType = setDurationType;
exports.setSuppressionFields = setSuppressionFields;
var _react = require("@testing-library/react");
var _combobox = require("../../../../common/test/eui/combobox");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

const COMBO_BOX_TOGGLE_BUTTON_TEST_ID = 'comboBoxToggleListButton';
async function setSuppressionFields(fieldNames) {
  const getAlertSuppressionFieldsComboBoxToggleButton = () => (0, _react.within)(_react.screen.getByTestId('alertSuppressionInput')).getByTestId(COMBO_BOX_TOGGLE_BUTTON_TEST_ID);
  await (0, _react.waitFor)(() => {
    expect(getAlertSuppressionFieldsComboBoxToggleButton()).toBeInTheDocument();
  });
  for (const fieldName of fieldNames) {
    await (0, _combobox.selectEuiComboBoxOption)({
      comboBoxToggleButton: getAlertSuppressionFieldsComboBoxToggleButton(),
      optionText: fieldName
    });
  }
}
function expectSuppressionFields(fieldNames) {
  for (const fieldName of fieldNames) {
    expect((0, _react.within)(_react.screen.getByTestId('alertSuppressionInput')).getByTitle(fieldName)).toBeInTheDocument();
  }
}
function setDurationType(value) {
  (0, _react.act)(() => {
    _react.fireEvent.click((0, _react.within)(_react.screen.getByTestId('alertSuppressionDuration')).getByText(value));
  });
}
function setDuration(value, unit) {
  (0, _react.act)(() => {
    _react.fireEvent.input((0, _react.within)(_react.screen.getByTestId('alertSuppressionDuration')).getByTestId('interval'), {
      target: {
        value: value.toString()
      }
    });
    _react.fireEvent.change((0, _react.within)(_react.screen.getByTestId('alertSuppressionDuration')).getByTestId('timeType'), {
      target: {
        value: unit
      }
    });
  });
}
function expectDuration(value, unit) {
  expect((0, _react.within)(_react.screen.getByTestId('alertSuppressionDuration')).getByTestId('interval')).toHaveValue(value);
  expect((0, _react.within)(_react.screen.getByTestId('alertSuppressionDuration')).getByTestId('timeType')).toHaveValue(unit);
}