"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GcpAccountTypeSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _asset_boxed_radio_group = require("../asset_boxed_radio_group");
var _gcp_credential_form = require("./gcp_credential_form");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGcpAccountTypeOptions = () => [{
  id: _constants.GCP_ORGANIZATION_ACCOUNT,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.gcpAccountType.gcpOrganizationLabel', {
    defaultMessage: 'GCP Organization'
  }),
  testId: 'gcpOrganizationAccountTestId'
}, {
  id: _constants.GCP_SINGLE_ACCOUNT,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.gcpAccountType.gcpSingleAccountLabel', {
    defaultMessage: 'Single Project'
  }),
  testId: 'gcpSingleAccountTestId'
}];
const getGcpAccountType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars['gcp.account_type']) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
};
const GcpAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  disabled
}) => {
  const gcpAccountTypeOptions = getGcpAccountTypeOptions();
  /* Create a subset of properties from GcpField to use for hiding value of Organization ID when switching account type from Organization to Single */
  const subsetOfGcpField = (({
    'gcp.organization_id': a
  }) => ({
    'gcp.organization_id': a
  }))(_gcp_credential_form.gcpField.fields);
  const fieldsToHide = (0, _gcp_credential_form.getInputVarsFields)(input, subsetOfGcpField);
  const fieldsSnapshot = (0, _react.useRef)({});
  const lastSetupAccessType = (0, _react.useRef)(undefined);
  const onSetupFormatChange = newSetupFormat => {
    if (newSetupFormat === 'single-account') {
      var _input$streams$0$vars3;
      // We need to store the current manual fields to restore them later
      fieldsSnapshot.current = Object.fromEntries(fieldsToHide.map(field => [field.id, {
        value: field.value
      }]));
      // We need to store the last manual credentials type to restore it later
      lastSetupAccessType.current = (_input$streams$0$vars3 = input.streams[0].vars) === null || _input$streams$0$vars3 === void 0 ? void 0 : _input$streams$0$vars3['gcp.account_type'].value;
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          value: 'single-account',
          type: 'text'
        },
        // Clearing fields from previous setup format to prevent exposing credentials
        // when switching from manual to cloud formation
        ...Object.fromEntries(fieldsToHide.map(field => [field.id, {
          value: undefined
        }]))
      }));
    } else {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          // Restoring last manual credentials type
          value: lastSetupAccessType.current || 'organization-account',
          type: 'text'
        },
        // Restoring fields from manual setup format if any
        ...fieldsSnapshot.current
      }));
    }
  };
  (0, _react.useEffect)(() => {
    if (!getGcpAccountType(input)) {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          value: _constants.GCP_ORGANIZATION_ACCOUNT,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.gcpAccountTypeDescriptionLabel",
    defaultMessage: "Select between single project or organization, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getGcpAccountType(input) || '',
    options: gcpAccountTypeOptions,
    onChange: accountType => accountType !== getGcpAccountType(input) && onSetupFormatChange(accountType),
    size: "m",
    name: "gcpAccountType"
  }), getGcpAccountType(input) === _constants.GCP_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.gcpAccountType.gcpOrganizationDescription",
    defaultMessage: "Connect Elastic to every GCP Project (current and future) in your environment by providing Elastic with read-only (configuration) access to your GCP organization"
  }))), getGcpAccountType(input) === _constants.GCP_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.gcpAccountType.gcpSingleAccountDescription",
    defaultMessage: "Deploying to a single project is suitable for an initial POC. To ensure complete coverage, it is strongly recommended to deploy Cloud Asset Discovery at the organization-level, which automatically connects all projects (both current and future)."
  }))));
};
exports.GcpAccountTypeSelect = GcpAccountTypeSelect;