"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAzureCredentialsForm = void 0;
var _react = require("react");
var _constants = require("./constants");
var _constants2 = require("../../../constants");
var _utils = require("../utils");
var _azure_credentials_form_options = require("./azure_credentials_form_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSetupFormatFromInput = input => {
  const credentialsType = getAzureCredentialsType(input);
  if (!credentialsType) {
    return _constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE;
  }
  if (credentialsType !== _constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE) {
    return _constants.AZURE_SETUP_FORMAT.MANUAL;
  }
  return _constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE;
};
const getAzureCredentialsType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars['azure.credentials.type']) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
};
const getAzureArmTemplateUrl = newPolicy => {
  var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
  const template = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants.CLOUDBEAT_AZURE)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.arm_template_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;
  return template || undefined;
};
const updateAzureArmTemplateUrlInPolicy = (newPolicy, updatePolicy, templateUrl) => {
  updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
    ...newPolicy,
    inputs: newPolicy.inputs.map(input => {
      if (input.type === _constants.CLOUDBEAT_AZURE) {
        return {
          ...input,
          config: {
            arm_template_url: {
              value: templateUrl
            }
          }
        };
      }
      return input;
    })
  });
};
const useUpdateAzureArmTemplate = ({
  packageInfo,
  newPolicy,
  updatePolicy,
  setupFormat
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    const azureArmTemplateUrl = getAzureArmTemplateUrl(newPolicy);
    if (setupFormat === _constants.AZURE_SETUP_FORMAT.MANUAL) {
      if (azureArmTemplateUrl) {
        updateAzureArmTemplateUrlInPolicy(newPolicy, updatePolicy, undefined);
      }
      return;
    }
    const templateUrl = (0, _utils.getArmTemplateUrlFromAssetPackage)(packageInfo);
    if (templateUrl === '') return;
    if (azureArmTemplateUrl === templateUrl) return;
    updateAzureArmTemplateUrlInPolicy(newPolicy, updatePolicy, templateUrl);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.arm_template_url, newPolicy, packageInfo, setupFormat]);
};
const useAzureCredentialsForm = ({
  newPolicy,
  input,
  packageInfo,
  updatePolicy
}) => {
  const azureCredentialsType = getAzureCredentialsType(input) || _constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE;
  const options = (0, _azure_credentials_form_options.getAzureCredentialsFormOptions)();
  const setupFormat = getSetupFormatFromInput(input);
  const group = options[azureCredentialsType];
  const fields = (0, _azure_credentials_form_options.getInputVarsFields)(input, group.fields);
  const fieldsSnapshot = (0, _react.useRef)({});
  const lastManualCredentialsType = (0, _react.useRef)(undefined);
  const documentationLink = _constants2.assetIntegrationDocsNavigation.azureGetStartedPath;
  useUpdateAzureArmTemplate({
    packageInfo,
    newPolicy,
    updatePolicy,
    setupFormat
  });
  const defaultAzureManualCredentialType = _constants.AZURE_CREDENTIALS_TYPE.MANAGED_IDENTITY;
  const onSetupFormatChange = newSetupFormat => {
    if (newSetupFormat === _constants.AZURE_SETUP_FORMAT.ARM_TEMPLATE) {
      fieldsSnapshot.current = Object.fromEntries(fields === null || fields === void 0 ? void 0 : fields.map(field => [field.id, {
        value: field.value
      }]));
      lastManualCredentialsType.current = getAzureCredentialsType(input);
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'azure.credentials.type': {
          value: _constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE,
          type: 'text'
        },
        ...Object.fromEntries(fields === null || fields === void 0 ? void 0 : fields.map(field => [field.id, {
          value: undefined
        }]))
      }));
    } else {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'azure.credentials.type': {
          value: lastManualCredentialsType.current || defaultAzureManualCredentialType,
          type: 'text'
        },
        ...fieldsSnapshot.current
      }));
    }
  };
  return {
    azureCredentialsType,
    setupFormat,
    group,
    fields,
    documentationLink,
    onSetupFormatChange
  };
};
exports.useAzureCredentialsForm = useAzureCredentialsForm;