"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeysEmptyPrompt = void 0;
exports.doesErrorIndicateBadQuery = doesErrorIndicateBadQuery;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_html_id = require("../../../components/use_html_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeysEmptyPrompt = ({
  error,
  readOnly,
  children
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordionId = (0, _use_html_id.useHtmlId)('apiKeysEmptyPrompt', 'accordion');
  if (error) {
    if (doesErrorIndicateAPIKeysAreDisabled(error)) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
        iconType: "warning",
        body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.disabledErrorMessage",
          defaultMessage: "API keys are disabled."
        })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: services.docLinks.links.security.apiKeyServiceSettings,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.docsLinkText",
          defaultMessage: "Learn how to enable API keys."
        }))))
      });
    }
    if (doesErrorIndicateUserHasNoPermissionsToManageAPIKeys(error)) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
        iconType: "lock",
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.forbiddenErrorMessage",
          defaultMessage: "You do not have permission to manage API keys."
        }))
      });
    }
    const ThrowError = () => {
      throw error;
    };
    const promptHeading = doesErrorIndicateBadQuery(error) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.badQueryErrorMessage",
      defaultMessage: "Could not load API keys as the query is incorrect."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.errorMessage",
      defaultMessage: "Could not load API keys."
    });
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "warning",
      body: /*#__PURE__*/_react.default.createElement("p", null, promptHeading),
      actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: accordionId,
        buttonClassName: (0, _css.css)({
          display: 'flex',
          justifyContent: 'center'
        }),
        buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: (0, _css.css)({
            fontWeight: euiTheme.font.weight.medium
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.technicalDetailsButton",
          defaultMessage: "Technical details"
        })),
        arrowDisplay: "right",
        paddingSize: "m"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        textAlign: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(ThrowError, null)))))
    });
  }
  if (readOnly) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "error",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeysEmptyPrompt.readOnlyEmptyTitle",
        defaultMessage: "You do not have permission to create API keys"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeysEmptyPrompt.readOnlyEmptyMessage",
        defaultMessage: "Please contact your administrator for more information"
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.emptyTitle",
      defaultMessage: "Create your first API key"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.emptyMessage",
      defaultMessage: "Allow external services to access the Elastic Stack on your behalf."
    })),
    actions: children
  });
};
exports.ApiKeysEmptyPrompt = ApiKeysEmptyPrompt;
function doesErrorIndicateAPIKeysAreDisabled(error) {
  var _error$body;
  const message = ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || '';
  return message.indexOf('disabled.feature="api_keys"') !== -1;
}
function doesErrorIndicateUserHasNoPermissionsToManageAPIKeys(error) {
  var _error$body2;
  return ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.statusCode) === 403;
}
function doesErrorIndicateBadQuery(error) {
  const message = (error === null || error === void 0 ? void 0 : error.message) || '';
  const errorString = (error === null || error === void 0 ? void 0 : error.name) || '';
  return errorString.indexOf('ResponseError') > -1 || message.indexOf('illegal_argument_exception') > -1;
}