"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduledReportsList = void 0;
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduledReportsList = async ({
  http,
  perPage,
  page
}) => {
  const query = {
    page,
    size: perPage
  };
  const res = await http.get(_reportingCommon.INTERNAL_ROUTES.SCHEDULED.LIST, {
    query
  });
  return {
    page: res.page,
    size: res.per_page,
    total: res.total,
    data: res.data
  };
};
exports.getScheduledReportsList = getScheduledReportsList;