"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackTraces = StackTraces;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _stacked_bar_chart = require("../stacked_bar_chart");
var _chart_grid = require("../chart_grid");
var _use_async = require("../../hooks/use_async");
var _async_component = require("../async_component");
var _subchart = require("../subchart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const displayOptions = [{
  id: _profilingUtils.StackTracesDisplayOption.StackTraces,
  iconType: 'visLine',
  label: _i18n.i18n.translate('xpack.profiling.stackTracesView.stackTracesCountButton', {
    defaultMessage: 'Stack traces'
  })
}, {
  id: _profilingUtils.StackTracesDisplayOption.Percentage,
  iconType: 'percent',
  label: _i18n.i18n.translate('xpack.profiling.stackTracesView.percentagesButton', {
    defaultMessage: 'Percentages'
  })
}];
function StackTraces({
  type,
  state,
  displayOption,
  onChangeDisplayOption,
  onStackedBarChartBrushEnd,
  limit,
  onShowMoreClick,
  onChartClick
}) {
  var _state$data$charts, _state$data, _charts$;
  const charts = (_state$data$charts = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.charts) !== null && _state$data$charts !== void 0 ? _state$data$charts : [];
  const isTracesType = type === _profilingUtils.TopNType.Traces;
  const [selectedSubchart, setSelectedSubchart] = (0, _react.useState)(undefined);
  const isExecutableType = type === _profilingUtils.TopNType.Executables;
  const displayAgentCallout = charts.length === 1 && ((_charts$ = charts[0]) === null || _charts$ === void 0 ? void 0 : _charts$.Category) === 'Other';
  function handleChartClick(selectedChart) {
    // When clicking on the charts on the Traces view, the flyout must open
    if (type === _profilingUtils.TopNType.Traces) {
      setSelectedSubchart(selectedChart);
    } else {
      onChartClick(selectedChart.Category);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, state.status === _use_async.AsyncStatus.Settled && isExecutableType && displayAgentCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.profiling.stackTraces.euiCallOut.wrongAgentTitle', {
      defaultMessage: 'No executable names available'
    })
  }, _i18n.i18n.translate('xpack.profiling.stackTraces.euiCallOut.wrongAgentMessage', {
    defaultMessage: 'This might be due to data from agents prior to v9.1.0 or due to data from OpenTelemetry agents that do not send executable names.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    idSelected: displayOption,
    type: "single",
    onChange: nextValue => {
      onChangeDisplayOption(nextValue);
    },
    options: displayOptions,
    legend: _i18n.i18n.translate('xpack.profiling.stackTracesView.displayOptionLegend', {
      defaultMessage: 'Display option'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, state, {
    style: {
      height: 400
    }
  }), /*#__PURE__*/_react.default.createElement(_stacked_bar_chart.StackedBarChart, {
    height: 400,
    charts: charts,
    asPercentages: displayOption === _profilingUtils.StackTracesDisplayOption.Percentage,
    onBrushEnd: onStackedBarChartBrushEnd,
    showFrames: isTracesType,
    onClick: handleChartClick
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "m"
  }, state, {
    style: {
      minHeight: 200
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.profiling.chartGrid.h1.topLabel', {
    defaultMessage: 'Top {size}',
    values: {
      size: onShowMoreClick ? charts.length : Math.min(limit, charts.length)
    }
  }))), /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    charts: charts,
    limit: limit,
    showFrames: isTracesType,
    onChartClick: handleChartClick
  })))), onShowMoreClick && charts.length > limit ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingStackTracesViewShowMoreButton",
    onClick: () => onShowMoreClick(limit + 10)
  }, _i18n.i18n.translate('xpack.profiling.stackTracesView.showMoreButton', {
    defaultMessage: 'Show more'
  }))) : null), selectedSubchart && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      setSelectedSubchart(undefined);
    }
  }, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
    style: {
      overflow: 'auto'
    },
    index: selectedSubchart.Index,
    color: selectedSubchart.Color,
    category: selectedSubchart.Category,
    label: selectedSubchart.Label,
    percentage: selectedSubchart.Percentage,
    metadata: selectedSubchart.Metadata,
    height: 200,
    data: selectedSubchart.Series,
    sample: null,
    showAxes: true,
    showFrames: isTracesType,
    padTitle: true
  })));
}