"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticPalette = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _color_fn_palette = require("../../classes/color_fn_palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This is not correctly returning the updated vis colors from eui.
 * All gradient function work correctly.
 */
const elasticPalette = exports.elasticPalette = new _color_fn_palette.KbnColorFnPalette({
  id: _constants.KbnPalette.Default,
  type: 'categorical',
  aliases: [_constants.KbnPalette.Default,
  // needed when switching between new and old themes
  'elastic_borealis',
  // placeholder - not yet used
  _constants.KbnPalette.Amsterdam // to assign to existing default palettes
  ],
  colorCount: 10,
  defaultNumberOfColors: 30,
  name: _i18n.i18n.translate('palettes.elastic.name', {
    defaultMessage: 'Elastic'
  }),
  tag: _i18n.i18n.translate('palettes.elastic.tag', {
    defaultMessage: 'Default'
  }),
  // Return exact colors requested given enough rotations
  colorFn: n => (0, _eui.euiPaletteColorBlind)({
    rotations: Math.ceil(n / 10)
  }).slice(0, n)
});