"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createModelProviderFactory = exports.createModelProvider = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility function to creates a {@link ModelProviderFactoryFn}
 */
const createModelProviderFactory = factoryOpts => opts => {
  return createModelProvider({
    ...factoryOpts,
    ...opts
  });
};

/**
 * Utility function to creates a {@link ModelProvider}
 */
exports.createModelProviderFactory = createModelProviderFactory;
const createModelProvider = ({
  inference,
  actions,
  request,
  defaultConnectorId
}) => {
  const getDefaultConnectorId = async () => {
    if (defaultConnectorId) {
      return defaultConnectorId;
    }
    const connectors = await (0, _utils.getConnectorList)({
      actions,
      request
    });
    const defaultConnector = (0, _utils.getDefaultConnector)({
      connectors
    });
    return defaultConnector.connectorId;
  };
  const getModel = async connectorId => {
    const chatModel = await inference.getChatModel({
      request,
      connectorId,
      chatModelOptions: {}
    });
    const inferenceClient = inference.getClient({
      request,
      bindTo: {
        connectorId
      }
    });
    return {
      chatModel,
      inferenceClient
    };
  };
  return {
    getDefaultModel: async () => getModel(await getDefaultConnectorId()),
    getModel: ({
      connectorId
    }) => getModel(connectorId)
  };
};
exports.createModelProvider = createModelProvider;