"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isToolCallStep = exports.isReasoningStep = exports.ConversationRoundStepType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Represents a user input that initiated a conversation round.
 */
/**
 * Represents the final answer from the agent in a conversation round.
 */
let ConversationRoundStepType = exports.ConversationRoundStepType = /*#__PURE__*/function (ConversationRoundStepType) {
  ConversationRoundStepType["toolCall"] = "toolCall";
  ConversationRoundStepType["reasoning"] = "reasoning";
  return ConversationRoundStepType;
}({}); // tool call step
/**
 * Represents a tool call with the corresponding result.
 */
const isToolCallStep = step => {
  return step.type === ConversationRoundStepType.toolCall;
};

// reasoning step
exports.isToolCallStep = isToolCallStep;
const isReasoningStep = step => {
  return step.type === ConversationRoundStepType.reasoning;
};

/**
 * Defines all possible types for round steps.
 */

/**
 * Represents a round in a conversation, containing all the information
 * related to this particular round.
 */
exports.isReasoningStep = isReasoningStep;