"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isToolResultEvent = exports.isToolCallEvent = exports.isRoundCompleteEvent = exports.isReasoningEvent = exports.isMessageCompleteEvent = exports.isMessageChunkEvent = exports.ChatAgentEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChatAgentEventType = exports.ChatAgentEventType = /*#__PURE__*/function (ChatAgentEventType) {
  ChatAgentEventType["toolCall"] = "toolCall";
  ChatAgentEventType["toolResult"] = "toolResult";
  ChatAgentEventType["reasoning"] = "reasoning";
  ChatAgentEventType["messageChunk"] = "messageChunk";
  ChatAgentEventType["messageComplete"] = "messageComplete";
  ChatAgentEventType["roundComplete"] = "roundComplete";
  return ChatAgentEventType;
}({}); // Tool call
const isToolCallEvent = event => {
  return event.type === ChatAgentEventType.toolCall;
};

// Tool result
exports.isToolCallEvent = isToolCallEvent;
const isToolResultEvent = event => {
  return event.type === ChatAgentEventType.toolResult;
};

// reasoning
exports.isToolResultEvent = isToolResultEvent;
const isReasoningEvent = event => {
  return event.type === ChatAgentEventType.reasoning;
};

// Message chunk
exports.isReasoningEvent = isReasoningEvent;
const isMessageChunkEvent = event => {
  return event.type === ChatAgentEventType.messageChunk;
};

// Message complete
exports.isMessageChunkEvent = isMessageChunkEvent;
const isMessageCompleteEvent = event => {
  return event.type === ChatAgentEventType.messageComplete;
};

// Round complete
exports.isMessageCompleteEvent = isMessageCompleteEvent;
const isRoundCompleteEvent = event => {
  return event.type === ChatAgentEventType.roundComplete;
};

// Composite type of all chat events
exports.isRoundCompleteEvent = isRoundCompleteEvent;