"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertUrl = exports.getAlertDetailsUrl = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertUrl = async (alertUuid, spaceId, startedAt, alertsLocator, publicBaseUrl) => {
  if (!publicBaseUrl || !alertsLocator || !alertUuid) return '';
  const rangeFrom = (0, _moment.default)(startedAt).subtract('5', 'minute').toISOString();
  return (await alertsLocator.getLocation({
    baseUrl: publicBaseUrl,
    spaceId,
    kuery: `kibana.alert.uuid: "${alertUuid}"`,
    rangeFrom
  })).path;
};
exports.getAlertUrl = getAlertUrl;
const getAlertDetailsUrl = (basePath, spaceId, alertUuid) => (0, _common.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, `/app/observability/alerts/${alertUuid}`);
exports.getAlertDetailsUrl = getAlertDetailsUrl;