"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepStatus = StepStatus;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StepStatus({
  status,
  title,
  message
}) {
  if (status === 'loading') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `obltOnboardingStepStatus-${status}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "transparent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, title)))));
  }
  if (status === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `obltOnboardingStepStatus-${status}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: title,
      color: "success",
      iconType: "check"
    }, message));
  }
  if (status === 'danger') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `obltOnboardingStepStatus-${status}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: title,
      color: "danger",
      iconType: "warning"
    }, message));
  }
  if (status === 'warning') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `obltOnboardingStepStatus-${status}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: title,
      color: "warning",
      iconType: "warning"
    }, message));
  }
  return null;
}