"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorSchema = exports.connectorSchema = {
  connectorId: {
    type: 'text',
    _meta: {
      description: 'The id of the connector.'
    }
  },
  name: {
    type: 'text',
    _meta: {
      description: 'The name of the connector.'
    }
  },
  type: {
    type: 'text',
    _meta: {
      description: 'The action type id of the connector.'
    }
  },
  modelFamily: {
    type: 'text',
    _meta: {
      description: 'The model family of the connector.'
    }
  },
  modelProvider: {
    type: 'text',
    _meta: {
      description: 'The model provider of the connector.'
    }
  },
  modelId: {
    type: 'text',
    _meta: {
      description: 'The model id of the connector, if applicable.',
      optional: true
    }
  }
};