"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorCell = DetectorCell;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Component for rendering a detector cell in the anomalies table, displaying the
 * description of the detector, and an icon if rules have been configured for the detector.
 */
function DetectorCell({
  detectorDescription,
  numberOfRules
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  let rulesIcon;
  if (numberOfRules !== undefined && numberOfRules > 0) {
    rulesIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.detectorCell.rulesConfiguredTooltip",
        defaultMessage: "rules have been configured for this detector"
      }),
      type: "controlsHorizontal",
      css: {
        marginLeft: euiTheme.size.xs
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, detectorDescription, rulesIcon);
}
DetectorCell.propTypes = {
  detectorDescription: _propTypes.default.string.isRequired,
  numberOfRules: _propTypes.default.number
};