"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmsFileLayers = getEmsFileLayers;
exports.getEmsTmsServices = getEmsTmsServices;
exports.getKibanaTileMap = getKibanaTileMap;
exports.isRetina = isRetina;
var _kibana_services = require("./kibana_services");
var _licensed_features = require("./licensed_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKibanaTileMap() {
  const mapsEms = (0, _kibana_services.getMapsEmsStart)();
  return mapsEms.config.tilemap ? mapsEms.config.tilemap : {};
}
async function getEmsFileLayers() {
  if (!(0, _kibana_services.getEMSSettings)().isEMSEnabled()) {
    return [];
  }
  return (await getEMSClient()).getFileLayers();
}
async function getEmsTmsServices() {
  if (!(0, _kibana_services.getEMSSettings)().isEMSEnabled()) {
    return [];
  }
  return (await getEMSClient()).getTMSServices();
}
let emsClientPromise = null;
let latestLicenseId;
async function getEMSClient() {
  if (!emsClientPromise) {
    emsClientPromise = new Promise(async (resolve, reject) => {
      try {
        const emsClient = await (0, _kibana_services.getMapsEmsStart)().createEMSClient();
        resolve(emsClient);
      } catch (error) {
        reject(error);
      }
    });
  }
  const emsClient = await emsClientPromise;
  const licenseId = (0, _licensed_features.getLicenseId)();
  if (latestLicenseId !== licenseId) {
    latestLicenseId = licenseId;
    emsClient.addQueryParams({
      license: licenseId ? licenseId : ''
    });
  }
  return emsClient;
}
function isRetina() {
  return window.devicePixelRatio === 2;
}