"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geoLineLayerWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _create_source_editor = require("./create_source_editor");
var _es_geo_line_source = require("./es_geo_line_source");
var _constants = require("../../../../common/constants");
var _vector_style = require("../../styles/vector/vector_style");
var _vector_layer = require("../../layers/vector_layer");
var _licensed_features = require("../../../licensed_features");
var _tracks_layer_icon = require("../../layers/wizards/icons/tracks_layer_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const geoLineLayerWizardConfig = exports.geoLineLayerWizardConfig = {
  id: _constants.WIZARD_ID.GEO_LINE,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.esGeoLineDescription', {
    defaultMessage: 'Create lines from points'
  }),
  disabledReason: _es_geo_line_source.REQUIRES_GOLD_LICENSE_MSG,
  icon: _tracks_layer_icon.TracksLayerIcon,
  getIsDisabled: () => {
    return !(0, _licensed_features.getIsGoldPlus)();
  },
  renderWizard: ({
    previewLayers
  }) => {
    const onSourceConfigChange = sourceConfig => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor: _es_geo_line_source.ESGeoLineSource.createDescriptor(sourceConfig),
        style: _vector_style.VectorStyle.createDescriptor({
          [_constants.VECTOR_STYLES.LINE_WIDTH]: {
            type: _constants.STYLE_TYPE.STATIC,
            options: {
              size: 2
            }
          }
        })
      });
      layerDescriptor.alpha = 1;
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      onSourceConfigChange: onSourceConfigChange
    });
  },
  title: _es_geo_line_source.geoLineTitle
};